/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.async.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.async.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.async.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.async.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.async.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.async.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.async.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.async.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostRequest;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostResponse;
import com.stackone.stackone_client_java.models.operations.StackoneMcpPostSecurity;
import com.stackone.stackone_client_java.models.operations.async.StackoneMcpPostResponse;
import com.stackone.stackone_client_java.operations.Operations;
import com.stackone.stackone_client_java.utils.AsyncRetries;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.NonRetryableException;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.SerializedBody;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class StackoneMcpPost {

    public static class Async
    extends Base
    implements Operations.AsyncRequestOperation<StackoneMcpPostRequest, StackoneMcpPostResponse> {
        private final ScheduledExecutorService retryScheduler;

        public Async(SDKConfiguration sdkConfiguration, StackoneMcpPostSecurity security, Optional<Options> options, ScheduledExecutorService retryScheduler, Headers _headers) {
            super(sdkConfiguration, security, options, _headers);
            this.retryScheduler = retryScheduler;
        }

        private CompletableFuture<HttpRequest> onBuildRequest(StackoneMcpPostRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request, new TypeReference<StackoneMcpPostRequest>(){});
            return this.sdkConfiguration.asyncHooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private CompletableFuture<HttpResponse<Blob>> onError(HttpResponse<Blob> response, Throwable error) {
            return this.sdkConfiguration.asyncHooks().afterError(this.createAfterErrorContext(), response, error);
        }

        private CompletableFuture<HttpResponse<Blob>> onSuccess(HttpResponse<Blob> response) {
            return this.sdkConfiguration.asyncHooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public CompletableFuture<HttpResponse<Blob>> doRequest(StackoneMcpPostRequest request) {
            AsyncRetries retries = AsyncRetries.builder().retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).scheduler(this.retryScheduler).build();
            return retries.retry(() -> ((CompletableFuture)((CompletableFuture)Exceptions.unchecked(() -> this.onBuildRequest(request)).get().thenCompose(this.client::sendAsync)).handle((resp, err) -> {
                if (err != null) {
                    return this.onError(null, (Throwable)err);
                }
                if (Utils.statusCodeMatches(resp.statusCode(), "400", "401", "403", "404", "408", "409", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                    return this.onError((HttpResponse<Blob>)resp, null);
                }
                return CompletableFuture.completedFuture(resp);
            })).thenCompose(Function.identity())).thenCompose(this::onSuccess);
        }

        @Override
        public CompletableFuture<StackoneMcpPostResponse> handleResponse(HttpResponse<Blob> response) {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            StackoneMcpPostResponse.Builder resBuilder = StackoneMcpPostResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            StackoneMcpPostResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                return CompletableFuture.completedFuture(res);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        BadRequestResponse out;
                        try {
                            out = (BadRequestResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<BadRequestResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        UnauthorizedResponse out;
                        try {
                            out = (UnauthorizedResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<UnauthorizedResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.ForbiddenResponse out;
                        try {
                            out = (com.stackone.stackone_client_java.models.errors.async.ForbiddenResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.async.ForbiddenResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        NotFoundResponse out;
                        try {
                            out = (NotFoundResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<NotFoundResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.RequestTimedOutResponse out;
                        try {
                            out = (com.stackone.stackone_client_java.models.errors.async.RequestTimedOutResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.async.RequestTimedOutResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        com.stackone.stackone_client_java.models.errors.async.ConflictResponse out;
                        try {
                            out = (com.stackone.stackone_client_java.models.errors.async.ConflictResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.async.ConflictResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        UnprocessableEntityResponse out;
                        try {
                            out = (UnprocessableEntityResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<UnprocessableEntityResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        TooManyRequestsResponse out;
                        try {
                            out = (TooManyRequestsResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<TooManyRequestsResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        InternalServerErrorResponse out;
                        try {
                            out = (InternalServerErrorResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<InternalServerErrorResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        NotImplementedResponse out;
                        try {
                            out = (NotImplementedResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<NotImplementedResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    return response.body().toByteArray().thenApply(bodyBytes -> {
                        BadGatewayResponse out;
                        try {
                            out = (BadGatewayResponse)Utils.mapper().readValue(bodyBytes, (TypeReference)new TypeReference<BadGatewayResponse>(){});
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        throw out;
                    });
                }
                return Utils.createAsyncApiError(response, "Unexpected content-type received: " + contentType);
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                return Utils.createAsyncApiError(response, "API error occurred");
            }
            return Utils.createAsyncApiError(response, "Unexpected status code received: " + response.statusCode());
        }
    }

    public static class Sync
    extends Base
    implements Operations.RequestOperation<StackoneMcpPostRequest, com.stackone.stackone_client_java.models.operations.StackoneMcpPostResponse> {
        public Sync(SDKConfiguration sdkConfiguration, StackoneMcpPostSecurity security, Optional<Options> options, Headers _headers) {
            super(sdkConfiguration, security, options, _headers);
        }

        private HttpRequest onBuildRequest(StackoneMcpPostRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request, new TypeReference<StackoneMcpPostRequest>(){});
            return this.sdkConfiguration.hooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return this.sdkConfiguration.hooks().afterError(this.createAfterErrorContext(), Optional.ofNullable(response), Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return this.sdkConfiguration.hooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(StackoneMcpPostRequest request) throws Exception {
            Retries retries = Retries.builder().action(() -> {
                HttpRequest r;
                try {
                    r = this.onBuildRequest(request);
                }
                catch (Exception e) {
                    throw new NonRetryableException(e);
                }
                try {
                    HttpResponse<InputStream> httpRes = this.client.send(r);
                    if (Utils.statusCodeMatches(httpRes.statusCode(), "400", "401", "403", "404", "408", "409", "422", "429", "4XX", "500", "501", "502", "5XX")) {
                        return this.onError(httpRes, null);
                    }
                    return httpRes;
                }
                catch (Exception e) {
                    return this.onError(null, e);
                }
            }).retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).build();
            return this.onSuccess(retries.run());
        }

        @Override
        public com.stackone.stackone_client_java.models.operations.StackoneMcpPostResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            StackoneMcpPostResponse.Builder resBuilder = com.stackone.stackone_client_java.models.operations.StackoneMcpPostResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            com.stackone.stackone_client_java.models.operations.StackoneMcpPostResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                return res;
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    com.stackone.stackone_client_java.models.errors.BadRequestResponse out = (com.stackone.stackone_client_java.models.errors.BadRequestResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.BadRequestResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "401")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    com.stackone.stackone_client_java.models.errors.UnauthorizedResponse out = (com.stackone.stackone_client_java.models.errors.UnauthorizedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.UnauthorizedResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ForbiddenResponse out = (ForbiddenResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ForbiddenResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    com.stackone.stackone_client_java.models.errors.NotFoundResponse out = (com.stackone.stackone_client_java.models.errors.NotFoundResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.NotFoundResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "408")) {
                res.withHeaders(response.headers().map());
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    RequestTimedOutResponse out = (RequestTimedOutResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<RequestTimedOutResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "409")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ConflictResponse out = (ConflictResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ConflictResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse out = (com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "429")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse out = (com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "500")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse out = (com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "501")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    com.stackone.stackone_client_java.models.errors.NotImplementedResponse out = (com.stackone.stackone_client_java.models.errors.NotImplementedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.NotImplementedResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "502")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    com.stackone.stackone_client_java.models.errors.BadGatewayResponse out = (com.stackone.stackone_client_java.models.errors.BadGatewayResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<com.stackone.stackone_client_java.models.errors.BadGatewayResponse>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            throw new SDKError(response, response.statusCode(), "Unexpected status code received: " + response.statusCode(), Utils.extractByteArrayFromBody(response));
        }
    }

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final StackoneMcpPostSecurity security;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;
        final Headers _headers;

        public Base(SDKConfiguration sdkConfiguration, StackoneMcpPostSecurity security, Optional<Options> options, Headers _headers) {
            this.sdkConfiguration = sdkConfiguration;
            this._headers = _headers;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.security = security;
            this.securitySource = SecuritySource.of(security);
            options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("429", "408");
            this.retryConfig = options.flatMap(Options::retryConfig).or(sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        Hook.BeforeRequestContextImpl createBeforeRequestContext() {
            return new Hook.BeforeRequestContextImpl(this.sdkConfiguration, this.baseUrl, "stackone_mcp_post", Optional.empty(), this.securitySource());
        }

        Hook.AfterSuccessContextImpl createAfterSuccessContext() {
            return new Hook.AfterSuccessContextImpl(this.sdkConfiguration, this.baseUrl, "stackone_mcp_post", Optional.empty(), this.securitySource());
        }

        Hook.AfterErrorContextImpl createAfterErrorContext() {
            return new Hook.AfterErrorContextImpl(this.sdkConfiguration, this.baseUrl, "stackone_mcp_post", Optional.empty(), this.securitySource());
        }

        <T, U> HttpRequest buildRequest(T request, TypeReference<U> typeReference) throws Exception {
            String url = Utils.generateURL(this.baseUrl, "/mcp");
            HTTPRequest req = new HTTPRequest(url, "POST");
            Object convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, typeReference);
            SerializedBody serializedRequestBody = Utils.serializeRequestBody(convertedRequest, "jsonRpcMessageDto", "json", false);
            if (serializedRequestBody == null) {
                throw new Exception("Request body is required");
            }
            req.setBody(Optional.ofNullable(serializedRequestBody));
            req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
            this._headers.forEach((k, list) -> list.forEach(v -> req.addHeader((String)k, (String)v)));
            req.addHeaders(Utils.getHeadersFromMetadata(request, null));
            Utils.configureSecurity(req, this.security);
            return req.build();
        }
    }
}

