/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackone.stackone_client_java.utils.BlockingParser;
import com.stackone.stackone_client_java.utils.EventStreamMessage;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class EventStream<T>
implements Iterable<T>,
AutoCloseable {
    private final BlockingParser<EventStreamMessage> parser;
    private final TypeReference<T> typeReference;
    private final ObjectMapper mapper;
    private final Optional<String> terminalMessage;

    public EventStream(InputStream in, TypeReference<T> typeReference, ObjectMapper mapper, Optional<String> terminalMessage) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8), 8192);
        this.parser = BlockingParser.forSSE(reader);
        this.typeReference = typeReference;
        this.mapper = mapper;
        this.terminalMessage = terminalMessage;
    }

    public Optional<T> next() throws IOException {
        return this.parser.next().filter(x -> this.terminalMessage.map(sentinel -> !sentinel.equals(x.data())).orElse(true)).map(x -> Utils.asType(x, this.mapper, this.typeReference));
    }

    public List<T> toList() {
        try {
            List list = this.stream().collect(Collectors.toList());
            return list;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new EventIterator(this);
    }

    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    static class EventIterator<T>
    implements Iterator<T> {
        private final EventStream<T> stream;
        private Optional<T> next = Optional.empty();

        EventIterator(EventStream<T> stream) {
            this.stream = stream;
        }

        @Override
        public T next() {
            this.load();
            if (this.next.isEmpty()) {
                throw new NoSuchElementException();
            }
            T v = this.next.get();
            this.next = Optional.empty();
            return v;
        }

        @Override
        public boolean hasNext() {
            this.load();
            return this.next.isPresent();
        }

        private void load() {
            if (this.next.isEmpty()) {
                try {
                    this.next = this.stream.next();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }
}

