/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.UnifiedUploadRequestDto;
import com.stackone.stackone_client_java.operations.DocumentsUploadFile;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;

public class DocumentsUploadFileRequestBuilder {

    private String xAccountId;
    private Optional<String> xStackoneApiSessionToken = Optional.empty();
    private UnifiedUploadRequestDto unifiedUploadRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public DocumentsUploadFileRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DocumentsUploadFileRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }
                
    public DocumentsUploadFileRequestBuilder xStackoneApiSessionToken(String xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = Optional.of(xStackoneApiSessionToken);
        return this;
    }

    public DocumentsUploadFileRequestBuilder xStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        return this;
    }

    public DocumentsUploadFileRequestBuilder unifiedUploadRequestDto(UnifiedUploadRequestDto unifiedUploadRequestDto) {
        Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
        this.unifiedUploadRequestDto = unifiedUploadRequestDto;
        return this;
    }
                
    public DocumentsUploadFileRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DocumentsUploadFileRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private DocumentsUploadFileRequest buildRequest() {

        DocumentsUploadFileRequest request = new DocumentsUploadFileRequest(xAccountId,
            xStackoneApiSessionToken,
            unifiedUploadRequestDto);

        return request;
    }

    public DocumentsUploadFileResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        RequestOperation<DocumentsUploadFileRequest, DocumentsUploadFileResponse> operation
              = new DocumentsUploadFile.Sync(sdkConfiguration, options, _headers);
        DocumentsUploadFileRequest request = buildRequest();

        return operation.handleResponse(operation.doRequest(request));
    }
}
