/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ParentQuestion;
import com.stackone.stackone_client_java.models.components.QuestionMultipleChoiceAnswers;
import com.stackone.stackone_client_java.models.components.QuestionRequired;
import com.stackone.stackone_client_java.models.components.QuestionType;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class Question {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="remote_id")
    private JsonNullable<String> remoteId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private JsonNullable<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="type")
    private JsonNullable<? extends QuestionType> type;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="text")
    private JsonNullable<String> text;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="required")
    private JsonNullable<? extends QuestionRequired> required;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="multiple_choice_answers")
    private JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="parent_question")
    private JsonNullable<? extends ParentQuestion> parentQuestion;

    @JsonCreator
    public Question(@JsonProperty(value="id") JsonNullable<String> id, @JsonProperty(value="remote_id") JsonNullable<String> remoteId, @JsonProperty(value="name") JsonNullable<String> name, @JsonProperty(value="type") JsonNullable<? extends QuestionType> type, @JsonProperty(value="text") JsonNullable<String> text, @JsonProperty(value="required") JsonNullable<? extends QuestionRequired> required, @JsonProperty(value="multiple_choice_answers") JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers, @JsonProperty(value="parent_question") JsonNullable<? extends ParentQuestion> parentQuestion) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(text, "text");
        Utils.checkNotNull(required, "required");
        Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
        Utils.checkNotNull(parentQuestion, "parentQuestion");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.type = type;
        this.text = text;
        this.required = required;
        this.multipleChoiceAnswers = multipleChoiceAnswers;
        this.parentQuestion = parentQuestion;
    }

    public Question() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends QuestionType>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends QuestionRequired>)JsonNullable.undefined(), (JsonNullable<? extends List<QuestionMultipleChoiceAnswers>>)JsonNullable.undefined(), (JsonNullable<? extends ParentQuestion>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return this.remoteId;
    }

    @JsonIgnore
    public JsonNullable<String> name() {
        return this.name;
    }

    @JsonIgnore
    public JsonNullable<QuestionType> type() {
        return this.type;
    }

    @JsonIgnore
    public JsonNullable<String> text() {
        return this.text;
    }

    @JsonIgnore
    public JsonNullable<QuestionRequired> required() {
        return this.required;
    }

    @JsonIgnore
    public JsonNullable<List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers() {
        return this.multipleChoiceAnswers;
    }

    @JsonIgnore
    public JsonNullable<ParentQuestion> parentQuestion() {
        return this.parentQuestion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Question withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public Question withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public Question withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of((Object)remoteId);
        return this;
    }

    public Question withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public Question withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    public Question withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public Question withType(QuestionType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of((Object)type);
        return this;
    }

    public Question withType(JsonNullable<? extends QuestionType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    public Question withText(String text) {
        Utils.checkNotNull(text, "text");
        this.text = JsonNullable.of((Object)text);
        return this;
    }

    public Question withText(JsonNullable<String> text) {
        Utils.checkNotNull(text, "text");
        this.text = text;
        return this;
    }

    public Question withRequired(QuestionRequired required) {
        Utils.checkNotNull(required, "required");
        this.required = JsonNullable.of((Object)required);
        return this;
    }

    public Question withRequired(JsonNullable<? extends QuestionRequired> required) {
        Utils.checkNotNull(required, "required");
        this.required = required;
        return this;
    }

    public Question withMultipleChoiceAnswers(List<QuestionMultipleChoiceAnswers> multipleChoiceAnswers) {
        Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
        this.multipleChoiceAnswers = JsonNullable.of(multipleChoiceAnswers);
        return this;
    }

    public Question withMultipleChoiceAnswers(JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers) {
        Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
        this.multipleChoiceAnswers = multipleChoiceAnswers;
        return this;
    }

    public Question withParentQuestion(ParentQuestion parentQuestion) {
        Utils.checkNotNull(parentQuestion, "parentQuestion");
        this.parentQuestion = JsonNullable.of((Object)parentQuestion);
        return this;
    }

    public Question withParentQuestion(JsonNullable<? extends ParentQuestion> parentQuestion) {
        Utils.checkNotNull(parentQuestion, "parentQuestion");
        this.parentQuestion = parentQuestion;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Question other = (Question)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.remoteId, other.remoteId) && Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.type, other.type) && Utils.enhancedDeepEquals(this.text, other.text) && Utils.enhancedDeepEquals(this.required, other.required) && Utils.enhancedDeepEquals(this.multipleChoiceAnswers, other.multipleChoiceAnswers) && Utils.enhancedDeepEquals(this.parentQuestion, other.parentQuestion);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.remoteId, this.name, this.type, this.text, this.required, this.multipleChoiceAnswers, this.parentQuestion);
    }

    public String toString() {
        return Utils.toString(Question.class, "id", this.id, "remoteId", this.remoteId, "name", this.name, "type", this.type, "text", this.text, "required", this.required, "multipleChoiceAnswers", this.multipleChoiceAnswers, "parentQuestion", this.parentQuestion);
    }

    public static final class Builder {
        private JsonNullable<String> id = JsonNullable.undefined();
        private JsonNullable<String> remoteId = JsonNullable.undefined();
        private JsonNullable<String> name = JsonNullable.undefined();
        private JsonNullable<? extends QuestionType> type = JsonNullable.undefined();
        private JsonNullable<String> text = JsonNullable.undefined();
        private JsonNullable<? extends QuestionRequired> required = JsonNullable.undefined();
        private JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers = JsonNullable.undefined();
        private JsonNullable<? extends ParentQuestion> parentQuestion = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of((Object)remoteId);
            return this;
        }

        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of((Object)name);
            return this;
        }

        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder type(QuestionType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of((Object)type);
            return this;
        }

        public Builder type(JsonNullable<? extends QuestionType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        public Builder text(String text) {
            Utils.checkNotNull(text, "text");
            this.text = JsonNullable.of((Object)text);
            return this;
        }

        public Builder text(JsonNullable<String> text) {
            Utils.checkNotNull(text, "text");
            this.text = text;
            return this;
        }

        public Builder required(QuestionRequired required) {
            Utils.checkNotNull(required, "required");
            this.required = JsonNullable.of((Object)required);
            return this;
        }

        public Builder required(JsonNullable<? extends QuestionRequired> required) {
            Utils.checkNotNull(required, "required");
            this.required = required;
            return this;
        }

        public Builder multipleChoiceAnswers(List<QuestionMultipleChoiceAnswers> multipleChoiceAnswers) {
            Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
            this.multipleChoiceAnswers = JsonNullable.of(multipleChoiceAnswers);
            return this;
        }

        public Builder multipleChoiceAnswers(JsonNullable<? extends List<QuestionMultipleChoiceAnswers>> multipleChoiceAnswers) {
            Utils.checkNotNull(multipleChoiceAnswers, "multipleChoiceAnswers");
            this.multipleChoiceAnswers = multipleChoiceAnswers;
            return this;
        }

        public Builder parentQuestion(ParentQuestion parentQuestion) {
            Utils.checkNotNull(parentQuestion, "parentQuestion");
            this.parentQuestion = JsonNullable.of((Object)parentQuestion);
            return this;
        }

        public Builder parentQuestion(JsonNullable<? extends ParentQuestion> parentQuestion) {
            Utils.checkNotNull(parentQuestion, "parentQuestion");
            this.parentQuestion = parentQuestion;
            return this;
        }

        public Question build() {
            return new Question(this.id, this.remoteId, this.name, this.type, this.text, this.required, this.multipleChoiceAnswers, this.parentQuestion);
        }
    }
}

