/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AssignmentLearningObjectTypeValue
 * 
 * <p>The StackOne unified learning object type.
 */
@JsonDeserialize(using = AssignmentLearningObjectTypeValue._Deserializer.class)
@JsonSerialize(using = AssignmentLearningObjectTypeValue._Serializer.class)
public class AssignmentLearningObjectTypeValue {

    public static final AssignmentLearningObjectTypeValue CONTENT = new AssignmentLearningObjectTypeValue("content");
    public static final AssignmentLearningObjectTypeValue COURSE = new AssignmentLearningObjectTypeValue("course");
    public static final AssignmentLearningObjectTypeValue COLLECTION = new AssignmentLearningObjectTypeValue("collection");
    public static final AssignmentLearningObjectTypeValue UNMAPPED_VALUE = new AssignmentLearningObjectTypeValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AssignmentLearningObjectTypeValue> values = createValuesMap();
    private static final Map<String, AssignmentLearningObjectTypeValueEnum> enums = createEnumsMap();

    private final String value;

    private AssignmentLearningObjectTypeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AssignmentLearningObjectTypeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AssignmentLearningObjectTypeValue
     */ 
    public static AssignmentLearningObjectTypeValue of(String value) {
        synchronized (AssignmentLearningObjectTypeValue.class) {
            return values.computeIfAbsent(value, v -> new AssignmentLearningObjectTypeValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AssignmentLearningObjectTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AssignmentLearningObjectTypeValue other = (AssignmentLearningObjectTypeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AssignmentLearningObjectTypeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AssignmentLearningObjectTypeValue[] values() {
        synchronized (AssignmentLearningObjectTypeValue.class) {
            return values.values().toArray(new AssignmentLearningObjectTypeValue[] {});
        }
    }

    private static final Map<String, AssignmentLearningObjectTypeValue> createValuesMap() {
        Map<String, AssignmentLearningObjectTypeValue> map = new LinkedHashMap<>();
        map.put("content", CONTENT);
        map.put("course", COURSE);
        map.put("collection", COLLECTION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AssignmentLearningObjectTypeValueEnum> createEnumsMap() {
        Map<String, AssignmentLearningObjectTypeValueEnum> map = new HashMap<>();
        map.put("content", AssignmentLearningObjectTypeValueEnum.CONTENT);
        map.put("course", AssignmentLearningObjectTypeValueEnum.COURSE);
        map.put("collection", AssignmentLearningObjectTypeValueEnum.COLLECTION);
        map.put("unmapped_value", AssignmentLearningObjectTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AssignmentLearningObjectTypeValue> {

        protected _Serializer() {
            super(AssignmentLearningObjectTypeValue.class);
        }

        @Override
        public void serialize(AssignmentLearningObjectTypeValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AssignmentLearningObjectTypeValue> {

        protected _Deserializer() {
            super(AssignmentLearningObjectTypeValue.class);
        }

        @Override
        public AssignmentLearningObjectTypeValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AssignmentLearningObjectTypeValue.of(v);
        }
    }
    
    public enum AssignmentLearningObjectTypeValueEnum {

        CONTENT("content"),
        COURSE("course"),
        COLLECTION("collection"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AssignmentLearningObjectTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

