/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.InterviewSourceValue;
import com.stackone.stackone_client_java.models.components.InterviewValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class InterviewInterviewStatus {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends InterviewValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends InterviewSourceValue> sourceValue;

    @JsonCreator
    public InterviewInterviewStatus(@JsonProperty(value="value") JsonNullable<? extends InterviewValue> value, @JsonProperty(value="source_value") JsonNullable<? extends InterviewSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public InterviewInterviewStatus() {
        this((JsonNullable<? extends InterviewValue>)JsonNullable.undefined(), (JsonNullable<? extends InterviewSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<InterviewValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<InterviewSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public InterviewInterviewStatus withValue(InterviewValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public InterviewInterviewStatus withValue(JsonNullable<? extends InterviewValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public InterviewInterviewStatus withSourceValue(InterviewSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public InterviewInterviewStatus withSourceValue(JsonNullable<? extends InterviewSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterviewInterviewStatus other = (InterviewInterviewStatus)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(InterviewInterviewStatus.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends InterviewValue> value = JsonNullable.undefined();
        private JsonNullable<? extends InterviewSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(InterviewValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends InterviewValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(InterviewSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends InterviewSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public InterviewInterviewStatus build() {
            return new InterviewInterviewStatus(this.value, this.sourceValue);
        }
    }
}

