/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.ScreeningCreateOrderRequestDto;
import com.stackone.stackone_client_java.models.components.ScreeningResultWebhook;
import com.stackone.stackone_client_java.models.operations.ScreeningCreateScreeningOrderRequest;
import com.stackone.stackone_client_java.models.operations.ScreeningCreateScreeningOrderRequestBuilder;
import com.stackone.stackone_client_java.models.operations.ScreeningCreateScreeningOrderResponse;
import com.stackone.stackone_client_java.models.operations.ScreeningGetScreeningPackageRequest;
import com.stackone.stackone_client_java.models.operations.ScreeningGetScreeningPackageRequestBuilder;
import com.stackone.stackone_client_java.models.operations.ScreeningGetScreeningPackageResponse;
import com.stackone.stackone_client_java.models.operations.ScreeningListScreeningPackagesRequest;
import com.stackone.stackone_client_java.models.operations.ScreeningListScreeningPackagesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.ScreeningListScreeningPackagesResponse;
import com.stackone.stackone_client_java.models.operations.ScreeningWebhookScreeningResultRequest;
import com.stackone.stackone_client_java.models.operations.ScreeningWebhookScreeningResultRequestBuilder;
import com.stackone.stackone_client_java.models.operations.ScreeningWebhookScreeningResultResponse;
import com.stackone.stackone_client_java.operations.ScreeningCreateScreeningOrder;
import com.stackone.stackone_client_java.operations.ScreeningGetScreeningPackage;
import com.stackone.stackone_client_java.operations.ScreeningListScreeningPackages;
import com.stackone.stackone_client_java.operations.ScreeningWebhookScreeningResult;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.String;
import java.util.Optional;


public class Screening {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final AsyncScreening asyncSDK;

    Screening(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.asyncSDK = new AsyncScreening(this, sdkConfiguration);
    }

    /**
     * Switches to the async SDK.
     * 
     * @return The async SDK
     */
    public AsyncScreening async() {
        return asyncSDK;
    }

    /**
     * List Screening Packages
     * 
     * @return The call builder
     */
    public ScreeningListScreeningPackagesRequestBuilder listScreeningPackages() {
        return new ScreeningListScreeningPackagesRequestBuilder(sdkConfiguration);
    }

    /**
     * List Screening Packages
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public ScreeningListScreeningPackagesResponse listScreeningPackages(ScreeningListScreeningPackagesRequest request) {
        return listScreeningPackages(request, Optional.empty());
    }

    /**
     * List Screening Packages
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public ScreeningListScreeningPackagesResponse listScreeningPackages(ScreeningListScreeningPackagesRequest request, Optional<Options> options) {
        RequestOperation<ScreeningListScreeningPackagesRequest, ScreeningListScreeningPackagesResponse> operation
              = new ScreeningListScreeningPackages.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Screening Package
     * 
     * @return The call builder
     */
    public ScreeningGetScreeningPackageRequestBuilder getScreeningPackage() {
        return new ScreeningGetScreeningPackageRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Screening Package
     * 
     * @param request The request object containing all the parameters for the API call.
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public ScreeningGetScreeningPackageResponse getScreeningPackage(ScreeningGetScreeningPackageRequest request) {
        return getScreeningPackage(request, Optional.empty());
    }

    /**
     * Get Screening Package
     * 
     * @param request The request object containing all the parameters for the API call.
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public ScreeningGetScreeningPackageResponse getScreeningPackage(ScreeningGetScreeningPackageRequest request, Optional<Options> options) {
        RequestOperation<ScreeningGetScreeningPackageRequest, ScreeningGetScreeningPackageResponse> operation
              = new ScreeningGetScreeningPackage.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Webhook Screening Result
     * 
     * @return The call builder
     */
    public ScreeningWebhookScreeningResultRequestBuilder webhookScreeningResult() {
        return new ScreeningWebhookScreeningResultRequestBuilder(sdkConfiguration);
    }

    /**
     * Webhook Screening Result
     * 
     * @param xAccountId The account identifier
     * @param screeningResultWebhook 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public ScreeningWebhookScreeningResultResponse webhookScreeningResult(String xAccountId, ScreeningResultWebhook screeningResultWebhook) {
        return webhookScreeningResult(xAccountId, screeningResultWebhook, Optional.empty());
    }

    /**
     * Webhook Screening Result
     * 
     * @param xAccountId The account identifier
     * @param screeningResultWebhook 
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public ScreeningWebhookScreeningResultResponse webhookScreeningResult(
            String xAccountId, ScreeningResultWebhook screeningResultWebhook,
            Optional<Options> options) {
        ScreeningWebhookScreeningResultRequest request =
            ScreeningWebhookScreeningResultRequest
                .builder()
                .xAccountId(xAccountId)
                .screeningResultWebhook(screeningResultWebhook)
                .build();
        RequestOperation<ScreeningWebhookScreeningResultRequest, ScreeningWebhookScreeningResultResponse> operation
              = new ScreeningWebhookScreeningResult.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Create Screening Order
     * 
     * @return The call builder
     */
    public ScreeningCreateScreeningOrderRequestBuilder createScreeningOrder() {
        return new ScreeningCreateScreeningOrderRequestBuilder(sdkConfiguration);
    }

    /**
     * Create Screening Order
     * 
     * @param xAccountId The account identifier
     * @param screeningCreateOrderRequestDto 
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public ScreeningCreateScreeningOrderResponse createScreeningOrder(String xAccountId, ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto) {
        return createScreeningOrder(xAccountId, screeningCreateOrderRequestDto, Optional.empty());
    }

    /**
     * Create Screening Order
     * 
     * @param xAccountId The account identifier
     * @param screeningCreateOrderRequestDto 
     * @param options additional options
     * @return The response from the API call
     * @throws RuntimeException subclass if the API call fails
     */
    public ScreeningCreateScreeningOrderResponse createScreeningOrder(
            String xAccountId, ScreeningCreateOrderRequestDto screeningCreateOrderRequestDto,
            Optional<Options> options) {
        ScreeningCreateScreeningOrderRequest request =
            ScreeningCreateScreeningOrderRequest
                .builder()
                .xAccountId(xAccountId)
                .screeningCreateOrderRequestDto(screeningCreateOrderRequestDto)
                .build();
        RequestOperation<ScreeningCreateScreeningOrderRequest, ScreeningCreateScreeningOrderResponse> operation
              = new ScreeningCreateScreeningOrder.Sync(sdkConfiguration, options, _headers);
        return operation.handleResponse(operation.doRequest(request));
    }

}
