/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * StackoneListActionsMetaQueryParamFilter
 * 
 * <p>Actions Metadata filters
 */
public class StackoneListActionsMetaQueryParamFilter {
    /**
     * A comma-separated list of connectors to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=connectors")
    private JsonNullable<String> connectors;

    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=account_ids")
    private JsonNullable<String> accountIds;

    /**
     * The action key to filter the results by
     */
    @SpeakeasyMetadata("queryParam:name=action_key")
    private JsonNullable<String> actionKey;

    @JsonCreator
    public StackoneListActionsMetaQueryParamFilter(
            JsonNullable<String> connectors,
            JsonNullable<String> accountIds,
            JsonNullable<String> actionKey) {
        Utils.checkNotNull(connectors, "connectors");
        Utils.checkNotNull(accountIds, "accountIds");
        Utils.checkNotNull(actionKey, "actionKey");
        this.connectors = connectors;
        this.accountIds = accountIds;
        this.actionKey = actionKey;
    }
    
    public StackoneListActionsMetaQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * A comma-separated list of connectors to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> connectors() {
        return connectors;
    }

    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> accountIds() {
        return accountIds;
    }

    /**
     * The action key to filter the results by
     */
    @JsonIgnore
    public JsonNullable<String> actionKey() {
        return actionKey;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * A comma-separated list of connectors to filter the results by.
     */
    public StackoneListActionsMetaQueryParamFilter withConnectors(String connectors) {
        Utils.checkNotNull(connectors, "connectors");
        this.connectors = JsonNullable.of(connectors);
        return this;
    }

    /**
     * A comma-separated list of connectors to filter the results by.
     */
    public StackoneListActionsMetaQueryParamFilter withConnectors(JsonNullable<String> connectors) {
        Utils.checkNotNull(connectors, "connectors");
        this.connectors = connectors;
        return this;
    }

    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    public StackoneListActionsMetaQueryParamFilter withAccountIds(String accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = JsonNullable.of(accountIds);
        return this;
    }

    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    public StackoneListActionsMetaQueryParamFilter withAccountIds(JsonNullable<String> accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = accountIds;
        return this;
    }

    /**
     * The action key to filter the results by
     */
    public StackoneListActionsMetaQueryParamFilter withActionKey(String actionKey) {
        Utils.checkNotNull(actionKey, "actionKey");
        this.actionKey = JsonNullable.of(actionKey);
        return this;
    }

    /**
     * The action key to filter the results by
     */
    public StackoneListActionsMetaQueryParamFilter withActionKey(JsonNullable<String> actionKey) {
        Utils.checkNotNull(actionKey, "actionKey");
        this.actionKey = actionKey;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneListActionsMetaQueryParamFilter other = (StackoneListActionsMetaQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.connectors, other.connectors) &&
            Utils.enhancedDeepEquals(this.accountIds, other.accountIds) &&
            Utils.enhancedDeepEquals(this.actionKey, other.actionKey);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            connectors, accountIds, actionKey);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneListActionsMetaQueryParamFilter.class,
                "connectors", connectors,
                "accountIds", accountIds,
                "actionKey", actionKey);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> connectors = JsonNullable.undefined();

        private JsonNullable<String> accountIds = JsonNullable.undefined();

        private JsonNullable<String> actionKey = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * A comma-separated list of connectors to filter the results by.
         */
        public Builder connectors(String connectors) {
            Utils.checkNotNull(connectors, "connectors");
            this.connectors = JsonNullable.of(connectors);
            return this;
        }

        /**
         * A comma-separated list of connectors to filter the results by.
         */
        public Builder connectors(JsonNullable<String> connectors) {
            Utils.checkNotNull(connectors, "connectors");
            this.connectors = connectors;
            return this;
        }


        /**
         * A comma-separated list of account IDs to filter the results by.
         */
        public Builder accountIds(String accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = JsonNullable.of(accountIds);
            return this;
        }

        /**
         * A comma-separated list of account IDs to filter the results by.
         */
        public Builder accountIds(JsonNullable<String> accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = accountIds;
            return this;
        }


        /**
         * The action key to filter the results by
         */
        public Builder actionKey(String actionKey) {
            Utils.checkNotNull(actionKey, "actionKey");
            this.actionKey = JsonNullable.of(actionKey);
            return this;
        }

        /**
         * The action key to filter the results by
         */
        public Builder actionKey(JsonNullable<String> actionKey) {
            Utils.checkNotNull(actionKey, "actionKey");
            this.actionKey = actionKey;
            return this;
        }

        public StackoneListActionsMetaQueryParamFilter build() {

            return new StackoneListActionsMetaQueryParamFilter(
                connectors, accountIds, actionKey);
        }

    }
}
