/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.HasSecurity;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class Security
implements HasSecurity {
    @SpeakeasyMetadata(value="security:scheme=true,type=http,subtype=basic,name=username")
    private Optional<String> username;
    @SpeakeasyMetadata(value="security:scheme=true,type=http,subtype=basic,name=password")
    private Optional<String> password;

    @JsonCreator
    public Security(Optional<String> username, Optional<String> password) {
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(password, "password");
        this.username = username;
        this.password = password;
    }

    public Security() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> username() {
        return this.username;
    }

    @JsonIgnore
    public Optional<String> password() {
        return this.password;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Security withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = Optional.ofNullable(username);
        return this;
    }

    public Security withUsername(Optional<String> username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    public Security withPassword(String password) {
        Utils.checkNotNull(password, "password");
        this.password = Optional.ofNullable(password);
        return this;
    }

    public Security withPassword(Optional<String> password) {
        Utils.checkNotNull(password, "password");
        this.password = password;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Security other = (Security)o;
        return Utils.enhancedDeepEquals(this.username, other.username) && Utils.enhancedDeepEquals(this.password, other.password);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.username, this.password);
    }

    public String toString() {
        return Utils.toString(Security.class, "username", this.username, "password", this.password);
    }

    public static final class Builder {
        private Optional<String> username = Optional.empty();
        private Optional<String> password = Optional.empty();

        private Builder() {
        }

        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = Optional.ofNullable(username);
            return this;
        }

        public Builder username(Optional<String> username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            Utils.checkNotNull(password, "password");
            this.password = Optional.ofNullable(password);
            return this;
        }

        public Builder password(Optional<String> password) {
            Utils.checkNotNull(password, "password");
            this.password = password;
            return this;
        }

        public Security build() {
            return new Security(this.username, this.password);
        }
    }
}

