/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class HRISBankDetailsAccountTypeValue {
    public static final HRISBankDetailsAccountTypeValue SAVINGS = new HRISBankDetailsAccountTypeValue("savings");
    public static final HRISBankDetailsAccountTypeValue CHECKING = new HRISBankDetailsAccountTypeValue("checking");
    public static final HRISBankDetailsAccountTypeValue CURRENT = new HRISBankDetailsAccountTypeValue("current");
    public static final HRISBankDetailsAccountTypeValue BUSINESS = new HRISBankDetailsAccountTypeValue("business");
    public static final HRISBankDetailsAccountTypeValue PERSONAL = new HRISBankDetailsAccountTypeValue("personal");
    public static final HRISBankDetailsAccountTypeValue OTHER = new HRISBankDetailsAccountTypeValue("other");
    public static final HRISBankDetailsAccountTypeValue UNMAPPED_VALUE = new HRISBankDetailsAccountTypeValue("unmapped_value");
    private static final Map<String, HRISBankDetailsAccountTypeValue> values = HRISBankDetailsAccountTypeValue.createValuesMap();
    private static final Map<String, HRISBankDetailsAccountTypeValueEnum> enums = HRISBankDetailsAccountTypeValue.createEnumsMap();
    private final String value;

    private HRISBankDetailsAccountTypeValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISBankDetailsAccountTypeValue of(String value) {
        Class<HRISBankDetailsAccountTypeValue> clazz = HRISBankDetailsAccountTypeValue.class;
        synchronized (HRISBankDetailsAccountTypeValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new HRISBankDetailsAccountTypeValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<HRISBankDetailsAccountTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HRISBankDetailsAccountTypeValue other = (HRISBankDetailsAccountTypeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "HRISBankDetailsAccountTypeValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRISBankDetailsAccountTypeValue[] values() {
        Class<HRISBankDetailsAccountTypeValue> clazz = HRISBankDetailsAccountTypeValue.class;
        synchronized (HRISBankDetailsAccountTypeValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new HRISBankDetailsAccountTypeValue[0]);
        }
    }

    private static final Map<String, HRISBankDetailsAccountTypeValue> createValuesMap() {
        LinkedHashMap<String, HRISBankDetailsAccountTypeValue> map = new LinkedHashMap<String, HRISBankDetailsAccountTypeValue>();
        map.put("savings", SAVINGS);
        map.put("checking", CHECKING);
        map.put("current", CURRENT);
        map.put("business", BUSINESS);
        map.put("personal", PERSONAL);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, HRISBankDetailsAccountTypeValueEnum> createEnumsMap() {
        HashMap<String, HRISBankDetailsAccountTypeValueEnum> map = new HashMap<String, HRISBankDetailsAccountTypeValueEnum>();
        map.put("savings", HRISBankDetailsAccountTypeValueEnum.SAVINGS);
        map.put("checking", HRISBankDetailsAccountTypeValueEnum.CHECKING);
        map.put("current", HRISBankDetailsAccountTypeValueEnum.CURRENT);
        map.put("business", HRISBankDetailsAccountTypeValueEnum.BUSINESS);
        map.put("personal", HRISBankDetailsAccountTypeValueEnum.PERSONAL);
        map.put("other", HRISBankDetailsAccountTypeValueEnum.OTHER);
        map.put("unmapped_value", HRISBankDetailsAccountTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum HRISBankDetailsAccountTypeValueEnum {
        SAVINGS("savings"),
        CHECKING("checking"),
        CURRENT("current"),
        BUSINESS("business"),
        PERSONAL("personal"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private HRISBankDetailsAccountTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<HRISBankDetailsAccountTypeValue> {
        protected _Deserializer() {
            super(HRISBankDetailsAccountTypeValue.class);
        }

        public HRISBankDetailsAccountTypeValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return HRISBankDetailsAccountTypeValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<HRISBankDetailsAccountTypeValue> {
        protected _Serializer() {
            super(HRISBankDetailsAccountTypeValue.class);
        }

        public void serialize(HRISBankDetailsAccountTypeValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

