/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

public class StatusReason {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="code")
    private JsonNullable<String> code;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="description")
    private JsonNullable<String> description;
    @JsonProperty(value="timestamp")
    private OffsetDateTime timestamp;

    @JsonCreator
    public StatusReason(@JsonProperty(value="code") JsonNullable<String> code, @JsonProperty(value="description") JsonNullable<String> description, @JsonProperty(value="timestamp") OffsetDateTime timestamp) {
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(timestamp, "timestamp");
        this.code = code;
        this.description = description;
        this.timestamp = timestamp;
    }

    public StatusReason(OffsetDateTime timestamp) {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), timestamp);
    }

    @JsonIgnore
    public JsonNullable<String> code() {
        return this.code;
    }

    @JsonIgnore
    public JsonNullable<String> description() {
        return this.description;
    }

    @JsonIgnore
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StatusReason withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = JsonNullable.of((Object)code);
        return this;
    }

    public StatusReason withCode(JsonNullable<String> code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    public StatusReason withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    public StatusReason withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public StatusReason withTimestamp(OffsetDateTime timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusReason other = (StatusReason)o;
        return Utils.enhancedDeepEquals(this.code, other.code) && Utils.enhancedDeepEquals(this.description, other.description) && Utils.enhancedDeepEquals(this.timestamp, other.timestamp);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.code, this.description, this.timestamp);
    }

    public String toString() {
        return Utils.toString(StatusReason.class, "code", this.code, "description", this.description, "timestamp", this.timestamp);
    }

    public static final class Builder {
        private JsonNullable<String> code = JsonNullable.undefined();
        private JsonNullable<String> description = JsonNullable.undefined();
        private OffsetDateTime timestamp;

        private Builder() {
        }

        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = JsonNullable.of((Object)code);
            return this;
        }

        public Builder code(JsonNullable<String> code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of((Object)description);
            return this;
        }

        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }

        public StatusReason build() {
            return new StatusReason(this.code, this.description, this.timestamp);
        }
    }
}

