/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.SchemeBasic;
import com.stackone.stackone_client_java.utils.HasSecurity;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneMcpPostSecurity
implements HasSecurity {
    @SpeakeasyMetadata(value="security:scheme=true,type=http,subtype=basic")
    private Optional<? extends SchemeBasic> basic;
    @SpeakeasyMetadata(value="security:scheme=true,type=apiKey,subtype=header,name=Authorization")
    private Optional<String> apiKey;

    @JsonCreator
    public StackoneMcpPostSecurity(Optional<? extends SchemeBasic> basic, Optional<String> apiKey) {
        Utils.checkNotNull(basic, "basic");
        Utils.checkNotNull(apiKey, "apiKey");
        this.basic = basic;
        this.apiKey = apiKey;
    }

    public StackoneMcpPostSecurity() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<SchemeBasic> basic() {
        return this.basic;
    }

    @JsonIgnore
    public Optional<String> apiKey() {
        return this.apiKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneMcpPostSecurity withBasic(SchemeBasic basic) {
        Utils.checkNotNull(basic, "basic");
        this.basic = Optional.ofNullable(basic);
        return this;
    }

    public StackoneMcpPostSecurity withBasic(Optional<? extends SchemeBasic> basic) {
        Utils.checkNotNull(basic, "basic");
        this.basic = basic;
        return this;
    }

    public StackoneMcpPostSecurity withApiKey(String apiKey) {
        Utils.checkNotNull(apiKey, "apiKey");
        this.apiKey = Optional.ofNullable(apiKey);
        return this;
    }

    public StackoneMcpPostSecurity withApiKey(Optional<String> apiKey) {
        Utils.checkNotNull(apiKey, "apiKey");
        this.apiKey = apiKey;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneMcpPostSecurity other = (StackoneMcpPostSecurity)o;
        return Utils.enhancedDeepEquals(this.basic, other.basic) && Utils.enhancedDeepEquals(this.apiKey, other.apiKey);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.basic, this.apiKey);
    }

    public String toString() {
        return Utils.toString(StackoneMcpPostSecurity.class, "basic", this.basic, "apiKey", this.apiKey);
    }

    public static final class Builder {
        private Optional<? extends SchemeBasic> basic = Optional.empty();
        private Optional<String> apiKey = Optional.empty();

        private Builder() {
        }

        public Builder basic(SchemeBasic basic) {
            Utils.checkNotNull(basic, "basic");
            this.basic = Optional.ofNullable(basic);
            return this;
        }

        public Builder basic(Optional<? extends SchemeBasic> basic) {
            Utils.checkNotNull(basic, "basic");
            this.basic = basic;
            return this;
        }

        public Builder apiKey(String apiKey) {
            Utils.checkNotNull(apiKey, "apiKey");
            this.apiKey = Optional.ofNullable(apiKey);
            return this;
        }

        public Builder apiKey(Optional<String> apiKey) {
            Utils.checkNotNull(apiKey, "apiKey");
            this.apiKey = apiKey;
            return this;
        }

        public StackoneMcpPostSecurity build() {
            return new StackoneMcpPostSecurity(this.basic, this.apiKey);
        }
    }
}

