/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ActionsRpcResponse;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StackoneRpcActionResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ActionsRpcResponse> actionsRpcResponse;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneRpcActionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ActionsRpcResponse> actionsRpcResponse, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.actionsRpcResponse = actionsRpcResponse;
        this.headers = headers;
    }

    public StackoneRpcActionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ActionsRpcResponse> actionsRpcResponse() {
        return this.actionsRpcResponse;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneRpcActionResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneRpcActionResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneRpcActionResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneRpcActionResponse withActionsRpcResponse(ActionsRpcResponse actionsRpcResponse) {
        Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
        this.actionsRpcResponse = Optional.ofNullable(actionsRpcResponse);
        return this;
    }

    public StackoneRpcActionResponse withActionsRpcResponse(Optional<? extends ActionsRpcResponse> actionsRpcResponse) {
        Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
        this.actionsRpcResponse = actionsRpcResponse;
        return this;
    }

    public StackoneRpcActionResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneRpcActionResponse other = (StackoneRpcActionResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.actionsRpcResponse, other.actionsRpcResponse) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.actionsRpcResponse, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneRpcActionResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "actionsRpcResponse", this.actionsRpcResponse, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ActionsRpcResponse> actionsRpcResponse = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder actionsRpcResponse(ActionsRpcResponse actionsRpcResponse) {
            Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
            this.actionsRpcResponse = Optional.ofNullable(actionsRpcResponse);
            return this;
        }

        public Builder actionsRpcResponse(Optional<? extends ActionsRpcResponse> actionsRpcResponse) {
            Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
            this.actionsRpcResponse = actionsRpcResponse;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneRpcActionResponse build() {
            return new StackoneRpcActionResponse(this.contentType, this.statusCode, this.rawResponse, this.actionsRpcResponse, this.headers);
        }
    }
}

