/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * AccountType
 * 
 * <p>The type of bank account
 */
public class AccountType {
    /**
     * The type of bank account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends HRISBankDetailsAccountTypeValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends HRISBankDetailsAccountTypeSourceValue> sourceValue;

    @JsonCreator
    public AccountType(
            @JsonProperty("value") JsonNullable<? extends HRISBankDetailsAccountTypeValue> value,
            @JsonProperty("source_value") JsonNullable<? extends HRISBankDetailsAccountTypeSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public AccountType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The type of bank account
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HRISBankDetailsAccountTypeValue> value() {
        return (JsonNullable<HRISBankDetailsAccountTypeValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HRISBankDetailsAccountTypeSourceValue> sourceValue() {
        return (JsonNullable<HRISBankDetailsAccountTypeSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The type of bank account
     */
    public AccountType withValue(HRISBankDetailsAccountTypeValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The type of bank account
     */
    public AccountType withValue(JsonNullable<? extends HRISBankDetailsAccountTypeValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public AccountType withSourceValue(HRISBankDetailsAccountTypeSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public AccountType withSourceValue(JsonNullable<? extends HRISBankDetailsAccountTypeSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountType other = (AccountType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountType.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends HRISBankDetailsAccountTypeValue> value = JsonNullable.undefined();

        private JsonNullable<? extends HRISBankDetailsAccountTypeSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The type of bank account
         */
        public Builder value(HRISBankDetailsAccountTypeValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The type of bank account
         */
        public Builder value(JsonNullable<? extends HRISBankDetailsAccountTypeValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(HRISBankDetailsAccountTypeSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends HRISBankDetailsAccountTypeSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public AccountType build() {

            return new AccountType(
                value, sourceValue);
        }

    }
}
