/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * AccountingAccountType
 * 
 * <p>Type of account
 */
public class AccountingAccountType {
    /**
     * Type of account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AccountingAccountValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AccountingAccountSourceValue> sourceValue;

    @JsonCreator
    public AccountingAccountType(
            @JsonProperty("value") JsonNullable<? extends AccountingAccountValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AccountingAccountSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public AccountingAccountType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Type of account
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingAccountValue> value() {
        return (JsonNullable<AccountingAccountValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingAccountSourceValue> sourceValue() {
        return (JsonNullable<AccountingAccountSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Type of account
     */
    public AccountingAccountType withValue(AccountingAccountValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * Type of account
     */
    public AccountingAccountType withValue(JsonNullable<? extends AccountingAccountValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public AccountingAccountType withSourceValue(AccountingAccountSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public AccountingAccountType withSourceValue(JsonNullable<? extends AccountingAccountSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingAccountType other = (AccountingAccountType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingAccountType.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends AccountingAccountValue> value = JsonNullable.undefined();

        private JsonNullable<? extends AccountingAccountSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Type of account
         */
        public Builder value(AccountingAccountValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * Type of account
         */
        public Builder value(JsonNullable<? extends AccountingAccountValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(AccountingAccountSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends AccountingAccountSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public AccountingAccountType build() {

            return new AccountingAccountType(
                value, sourceValue);
        }

    }
}
