/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class AccountingJournal {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * ID of the company this journal belongs to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("company_id")
    private JsonNullable<String> companyId;

    /**
     * Reference number for the journal
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("reference")
    private JsonNullable<String> reference;

    /**
     * Memo or description for the journal
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("memo")
    private JsonNullable<String> memo;

    /**
     * Date of the journal transaction
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("transaction_date")
    private JsonNullable<OffsetDateTime> transactionDate;

    /**
     * Status of the journal
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends AccountingJournalStatus> status;

    /**
     * List of journal lines
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("lines")
    private JsonNullable<? extends List<JournalLine>> lines;

    /**
     * Timestamp when the journal was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Timestamp when the journal was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * Timestamp when the journal was posted
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("posted_at")
    private JsonNullable<OffsetDateTime> postedAt;

    @JsonCreator
    public AccountingJournal(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("company_id") JsonNullable<String> companyId,
            @JsonProperty("reference") JsonNullable<String> reference,
            @JsonProperty("memo") JsonNullable<String> memo,
            @JsonProperty("transaction_date") JsonNullable<OffsetDateTime> transactionDate,
            @JsonProperty("status") JsonNullable<? extends AccountingJournalStatus> status,
            @JsonProperty("lines") JsonNullable<? extends List<JournalLine>> lines,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("posted_at") JsonNullable<OffsetDateTime> postedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(companyId, "companyId");
        Utils.checkNotNull(reference, "reference");
        Utils.checkNotNull(memo, "memo");
        Utils.checkNotNull(transactionDate, "transactionDate");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(lines, "lines");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(postedAt, "postedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.companyId = companyId;
        this.reference = reference;
        this.memo = memo;
        this.transactionDate = transactionDate;
        this.status = status;
        this.lines = lines;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.postedAt = postedAt;
    }
    
    public AccountingJournal() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * ID of the company this journal belongs to
     */
    @JsonIgnore
    public JsonNullable<String> companyId() {
        return companyId;
    }

    /**
     * Reference number for the journal
     */
    @JsonIgnore
    public JsonNullable<String> reference() {
        return reference;
    }

    /**
     * Memo or description for the journal
     */
    @JsonIgnore
    public JsonNullable<String> memo() {
        return memo;
    }

    /**
     * Date of the journal transaction
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> transactionDate() {
        return transactionDate;
    }

    /**
     * Status of the journal
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountingJournalStatus> status() {
        return (JsonNullable<AccountingJournalStatus>) status;
    }

    /**
     * List of journal lines
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<JournalLine>> lines() {
        return (JsonNullable<List<JournalLine>>) lines;
    }

    /**
     * Timestamp when the journal was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Timestamp when the journal was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * Timestamp when the journal was posted
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> postedAt() {
        return postedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public AccountingJournal withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public AccountingJournal withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AccountingJournal withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AccountingJournal withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * ID of the company this journal belongs to
     */
    public AccountingJournal withCompanyId(String companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = JsonNullable.of(companyId);
        return this;
    }

    /**
     * ID of the company this journal belongs to
     */
    public AccountingJournal withCompanyId(JsonNullable<String> companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = companyId;
        return this;
    }

    /**
     * Reference number for the journal
     */
    public AccountingJournal withReference(String reference) {
        Utils.checkNotNull(reference, "reference");
        this.reference = JsonNullable.of(reference);
        return this;
    }

    /**
     * Reference number for the journal
     */
    public AccountingJournal withReference(JsonNullable<String> reference) {
        Utils.checkNotNull(reference, "reference");
        this.reference = reference;
        return this;
    }

    /**
     * Memo or description for the journal
     */
    public AccountingJournal withMemo(String memo) {
        Utils.checkNotNull(memo, "memo");
        this.memo = JsonNullable.of(memo);
        return this;
    }

    /**
     * Memo or description for the journal
     */
    public AccountingJournal withMemo(JsonNullable<String> memo) {
        Utils.checkNotNull(memo, "memo");
        this.memo = memo;
        return this;
    }

    /**
     * Date of the journal transaction
     */
    public AccountingJournal withTransactionDate(OffsetDateTime transactionDate) {
        Utils.checkNotNull(transactionDate, "transactionDate");
        this.transactionDate = JsonNullable.of(transactionDate);
        return this;
    }

    /**
     * Date of the journal transaction
     */
    public AccountingJournal withTransactionDate(JsonNullable<OffsetDateTime> transactionDate) {
        Utils.checkNotNull(transactionDate, "transactionDate");
        this.transactionDate = transactionDate;
        return this;
    }

    /**
     * Status of the journal
     */
    public AccountingJournal withStatus(AccountingJournalStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * Status of the journal
     */
    public AccountingJournal withStatus(JsonNullable<? extends AccountingJournalStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * List of journal lines
     */
    public AccountingJournal withLines(List<JournalLine> lines) {
        Utils.checkNotNull(lines, "lines");
        this.lines = JsonNullable.of(lines);
        return this;
    }

    /**
     * List of journal lines
     */
    public AccountingJournal withLines(JsonNullable<? extends List<JournalLine>> lines) {
        Utils.checkNotNull(lines, "lines");
        this.lines = lines;
        return this;
    }

    /**
     * Timestamp when the journal was created
     */
    public AccountingJournal withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Timestamp when the journal was created
     */
    public AccountingJournal withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Timestamp when the journal was last updated
     */
    public AccountingJournal withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * Timestamp when the journal was last updated
     */
    public AccountingJournal withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * Timestamp when the journal was posted
     */
    public AccountingJournal withPostedAt(OffsetDateTime postedAt) {
        Utils.checkNotNull(postedAt, "postedAt");
        this.postedAt = JsonNullable.of(postedAt);
        return this;
    }

    /**
     * Timestamp when the journal was posted
     */
    public AccountingJournal withPostedAt(JsonNullable<OffsetDateTime> postedAt) {
        Utils.checkNotNull(postedAt, "postedAt");
        this.postedAt = postedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingJournal other = (AccountingJournal) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.companyId, other.companyId) &&
            Utils.enhancedDeepEquals(this.reference, other.reference) &&
            Utils.enhancedDeepEquals(this.memo, other.memo) &&
            Utils.enhancedDeepEquals(this.transactionDate, other.transactionDate) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.lines, other.lines) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.postedAt, other.postedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, companyId,
            reference, memo, transactionDate,
            status, lines, createdAt,
            updatedAt, postedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingJournal.class,
                "id", id,
                "remoteId", remoteId,
                "companyId", companyId,
                "reference", reference,
                "memo", memo,
                "transactionDate", transactionDate,
                "status", status,
                "lines", lines,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "postedAt", postedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> companyId = JsonNullable.undefined();

        private JsonNullable<String> reference = JsonNullable.undefined();

        private JsonNullable<String> memo = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> transactionDate = JsonNullable.undefined();

        private JsonNullable<? extends AccountingJournalStatus> status = JsonNullable.undefined();

        private JsonNullable<? extends List<JournalLine>> lines = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> postedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * ID of the company this journal belongs to
         */
        public Builder companyId(String companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = JsonNullable.of(companyId);
            return this;
        }

        /**
         * ID of the company this journal belongs to
         */
        public Builder companyId(JsonNullable<String> companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = companyId;
            return this;
        }


        /**
         * Reference number for the journal
         */
        public Builder reference(String reference) {
            Utils.checkNotNull(reference, "reference");
            this.reference = JsonNullable.of(reference);
            return this;
        }

        /**
         * Reference number for the journal
         */
        public Builder reference(JsonNullable<String> reference) {
            Utils.checkNotNull(reference, "reference");
            this.reference = reference;
            return this;
        }


        /**
         * Memo or description for the journal
         */
        public Builder memo(String memo) {
            Utils.checkNotNull(memo, "memo");
            this.memo = JsonNullable.of(memo);
            return this;
        }

        /**
         * Memo or description for the journal
         */
        public Builder memo(JsonNullable<String> memo) {
            Utils.checkNotNull(memo, "memo");
            this.memo = memo;
            return this;
        }


        /**
         * Date of the journal transaction
         */
        public Builder transactionDate(OffsetDateTime transactionDate) {
            Utils.checkNotNull(transactionDate, "transactionDate");
            this.transactionDate = JsonNullable.of(transactionDate);
            return this;
        }

        /**
         * Date of the journal transaction
         */
        public Builder transactionDate(JsonNullable<OffsetDateTime> transactionDate) {
            Utils.checkNotNull(transactionDate, "transactionDate");
            this.transactionDate = transactionDate;
            return this;
        }


        /**
         * Status of the journal
         */
        public Builder status(AccountingJournalStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * Status of the journal
         */
        public Builder status(JsonNullable<? extends AccountingJournalStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * List of journal lines
         */
        public Builder lines(List<JournalLine> lines) {
            Utils.checkNotNull(lines, "lines");
            this.lines = JsonNullable.of(lines);
            return this;
        }

        /**
         * List of journal lines
         */
        public Builder lines(JsonNullable<? extends List<JournalLine>> lines) {
            Utils.checkNotNull(lines, "lines");
            this.lines = lines;
            return this;
        }


        /**
         * Timestamp when the journal was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Timestamp when the journal was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * Timestamp when the journal was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * Timestamp when the journal was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }


        /**
         * Timestamp when the journal was posted
         */
        public Builder postedAt(OffsetDateTime postedAt) {
            Utils.checkNotNull(postedAt, "postedAt");
            this.postedAt = JsonNullable.of(postedAt);
            return this;
        }

        /**
         * Timestamp when the journal was posted
         */
        public Builder postedAt(JsonNullable<OffsetDateTime> postedAt) {
            Utils.checkNotNull(postedAt, "postedAt");
            this.postedAt = postedAt;
            return this;
        }

        public AccountingJournal build() {

            return new AccountingJournal(
                id, remoteId, companyId,
                reference, memo, transactionDate,
                status, lines, createdAt,
                updatedAt, postedAt);
        }

    }
}
