/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class ActionsMeta {
    /**
     * The version of the actions metadata
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("version")
    private JsonNullable<String> version;

    /**
     * The name of the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The unique key for the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("key")
    private JsonNullable<String> key;

    /**
     * The icon URL for the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("icon")
    private JsonNullable<String> icon;

    /**
     * The description of the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The authentication methods supported by the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("authentication")
    private JsonNullable<? extends List<AuthenticationMetaItem>> authentication;

    /**
     * The list of actions available for this provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("actions")
    private JsonNullable<? extends List<ActionMetaItem>> actions;

    @JsonCreator
    public ActionsMeta(
            @JsonProperty("version") JsonNullable<String> version,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("key") JsonNullable<String> key,
            @JsonProperty("icon") JsonNullable<String> icon,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("authentication") JsonNullable<? extends List<AuthenticationMetaItem>> authentication,
            @JsonProperty("actions") JsonNullable<? extends List<ActionMetaItem>> actions) {
        Utils.checkNotNull(version, "version");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(key, "key");
        Utils.checkNotNull(icon, "icon");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(authentication, "authentication");
        Utils.checkNotNull(actions, "actions");
        this.version = version;
        this.name = name;
        this.key = key;
        this.icon = icon;
        this.description = description;
        this.authentication = authentication;
        this.actions = actions;
    }
    
    public ActionsMeta() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * The version of the actions metadata
     */
    @JsonIgnore
    public JsonNullable<String> version() {
        return version;
    }

    /**
     * The name of the provider
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The unique key for the provider
     */
    @JsonIgnore
    public JsonNullable<String> key() {
        return key;
    }

    /**
     * The icon URL for the provider
     */
    @JsonIgnore
    public JsonNullable<String> icon() {
        return icon;
    }

    /**
     * The description of the provider
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The authentication methods supported by the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<AuthenticationMetaItem>> authentication() {
        return (JsonNullable<List<AuthenticationMetaItem>>) authentication;
    }

    /**
     * The list of actions available for this provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ActionMetaItem>> actions() {
        return (JsonNullable<List<ActionMetaItem>>) actions;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The version of the actions metadata
     */
    public ActionsMeta withVersion(String version) {
        Utils.checkNotNull(version, "version");
        this.version = JsonNullable.of(version);
        return this;
    }

    /**
     * The version of the actions metadata
     */
    public ActionsMeta withVersion(JsonNullable<String> version) {
        Utils.checkNotNull(version, "version");
        this.version = version;
        return this;
    }

    /**
     * The name of the provider
     */
    public ActionsMeta withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the provider
     */
    public ActionsMeta withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The unique key for the provider
     */
    public ActionsMeta withKey(String key) {
        Utils.checkNotNull(key, "key");
        this.key = JsonNullable.of(key);
        return this;
    }

    /**
     * The unique key for the provider
     */
    public ActionsMeta withKey(JsonNullable<String> key) {
        Utils.checkNotNull(key, "key");
        this.key = key;
        return this;
    }

    /**
     * The icon URL for the provider
     */
    public ActionsMeta withIcon(String icon) {
        Utils.checkNotNull(icon, "icon");
        this.icon = JsonNullable.of(icon);
        return this;
    }

    /**
     * The icon URL for the provider
     */
    public ActionsMeta withIcon(JsonNullable<String> icon) {
        Utils.checkNotNull(icon, "icon");
        this.icon = icon;
        return this;
    }

    /**
     * The description of the provider
     */
    public ActionsMeta withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The description of the provider
     */
    public ActionsMeta withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The authentication methods supported by the provider
     */
    public ActionsMeta withAuthentication(List<AuthenticationMetaItem> authentication) {
        Utils.checkNotNull(authentication, "authentication");
        this.authentication = JsonNullable.of(authentication);
        return this;
    }

    /**
     * The authentication methods supported by the provider
     */
    public ActionsMeta withAuthentication(JsonNullable<? extends List<AuthenticationMetaItem>> authentication) {
        Utils.checkNotNull(authentication, "authentication");
        this.authentication = authentication;
        return this;
    }

    /**
     * The list of actions available for this provider
     */
    public ActionsMeta withActions(List<ActionMetaItem> actions) {
        Utils.checkNotNull(actions, "actions");
        this.actions = JsonNullable.of(actions);
        return this;
    }

    /**
     * The list of actions available for this provider
     */
    public ActionsMeta withActions(JsonNullable<? extends List<ActionMetaItem>> actions) {
        Utils.checkNotNull(actions, "actions");
        this.actions = actions;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ActionsMeta other = (ActionsMeta) o;
        return 
            Utils.enhancedDeepEquals(this.version, other.version) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.key, other.key) &&
            Utils.enhancedDeepEquals(this.icon, other.icon) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.authentication, other.authentication) &&
            Utils.enhancedDeepEquals(this.actions, other.actions);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            version, name, key,
            icon, description, authentication,
            actions);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ActionsMeta.class,
                "version", version,
                "name", name,
                "key", key,
                "icon", icon,
                "description", description,
                "authentication", authentication,
                "actions", actions);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> version = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> key = JsonNullable.undefined();

        private JsonNullable<String> icon = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<? extends List<AuthenticationMetaItem>> authentication = JsonNullable.undefined();

        private JsonNullable<? extends List<ActionMetaItem>> actions = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The version of the actions metadata
         */
        public Builder version(String version) {
            Utils.checkNotNull(version, "version");
            this.version = JsonNullable.of(version);
            return this;
        }

        /**
         * The version of the actions metadata
         */
        public Builder version(JsonNullable<String> version) {
            Utils.checkNotNull(version, "version");
            this.version = version;
            return this;
        }


        /**
         * The name of the provider
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the provider
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The unique key for the provider
         */
        public Builder key(String key) {
            Utils.checkNotNull(key, "key");
            this.key = JsonNullable.of(key);
            return this;
        }

        /**
         * The unique key for the provider
         */
        public Builder key(JsonNullable<String> key) {
            Utils.checkNotNull(key, "key");
            this.key = key;
            return this;
        }


        /**
         * The icon URL for the provider
         */
        public Builder icon(String icon) {
            Utils.checkNotNull(icon, "icon");
            this.icon = JsonNullable.of(icon);
            return this;
        }

        /**
         * The icon URL for the provider
         */
        public Builder icon(JsonNullable<String> icon) {
            Utils.checkNotNull(icon, "icon");
            this.icon = icon;
            return this;
        }


        /**
         * The description of the provider
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The description of the provider
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * The authentication methods supported by the provider
         */
        public Builder authentication(List<AuthenticationMetaItem> authentication) {
            Utils.checkNotNull(authentication, "authentication");
            this.authentication = JsonNullable.of(authentication);
            return this;
        }

        /**
         * The authentication methods supported by the provider
         */
        public Builder authentication(JsonNullable<? extends List<AuthenticationMetaItem>> authentication) {
            Utils.checkNotNull(authentication, "authentication");
            this.authentication = authentication;
            return this;
        }


        /**
         * The list of actions available for this provider
         */
        public Builder actions(List<ActionMetaItem> actions) {
            Utils.checkNotNull(actions, "actions");
            this.actions = JsonNullable.of(actions);
            return this;
        }

        /**
         * The list of actions available for this provider
         */
        public Builder actions(JsonNullable<? extends List<ActionMetaItem>> actions) {
            Utils.checkNotNull(actions, "actions");
            this.actions = actions;
            return this;
        }

        public ActionsMeta build() {

            return new ActionsMeta(
                version, name, key,
                icon, description, authentication,
                actions);
        }

    }
}
