/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AtsCreateOfferRequestDtoValue
 * 
 * <p>The status of the offer.
 */
@JsonDeserialize(using = AtsCreateOfferRequestDtoValue._Deserializer.class)
@JsonSerialize(using = AtsCreateOfferRequestDtoValue._Serializer.class)
public class AtsCreateOfferRequestDtoValue {

    public static final AtsCreateOfferRequestDtoValue PENDING = new AtsCreateOfferRequestDtoValue("pending");
    public static final AtsCreateOfferRequestDtoValue RETRACTED = new AtsCreateOfferRequestDtoValue("retracted");
    public static final AtsCreateOfferRequestDtoValue ACCEPTED = new AtsCreateOfferRequestDtoValue("accepted");
    public static final AtsCreateOfferRequestDtoValue REJECTED = new AtsCreateOfferRequestDtoValue("rejected");
    public static final AtsCreateOfferRequestDtoValue CREATED = new AtsCreateOfferRequestDtoValue("created");
    public static final AtsCreateOfferRequestDtoValue APPROVED = new AtsCreateOfferRequestDtoValue("approved");
    public static final AtsCreateOfferRequestDtoValue NOT_APPROVED = new AtsCreateOfferRequestDtoValue("not_approved");
    public static final AtsCreateOfferRequestDtoValue UNMAPPED_VALUE = new AtsCreateOfferRequestDtoValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AtsCreateOfferRequestDtoValue> values = createValuesMap();
    private static final Map<String, AtsCreateOfferRequestDtoValueEnum> enums = createEnumsMap();

    private final String value;

    private AtsCreateOfferRequestDtoValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AtsCreateOfferRequestDtoValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AtsCreateOfferRequestDtoValue
     */ 
    public static AtsCreateOfferRequestDtoValue of(String value) {
        synchronized (AtsCreateOfferRequestDtoValue.class) {
            return values.computeIfAbsent(value, v -> new AtsCreateOfferRequestDtoValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AtsCreateOfferRequestDtoValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AtsCreateOfferRequestDtoValue other = (AtsCreateOfferRequestDtoValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AtsCreateOfferRequestDtoValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AtsCreateOfferRequestDtoValue[] values() {
        synchronized (AtsCreateOfferRequestDtoValue.class) {
            return values.values().toArray(new AtsCreateOfferRequestDtoValue[] {});
        }
    }

    private static final Map<String, AtsCreateOfferRequestDtoValue> createValuesMap() {
        Map<String, AtsCreateOfferRequestDtoValue> map = new LinkedHashMap<>();
        map.put("pending", PENDING);
        map.put("retracted", RETRACTED);
        map.put("accepted", ACCEPTED);
        map.put("rejected", REJECTED);
        map.put("created", CREATED);
        map.put("approved", APPROVED);
        map.put("not_approved", NOT_APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AtsCreateOfferRequestDtoValueEnum> createEnumsMap() {
        Map<String, AtsCreateOfferRequestDtoValueEnum> map = new HashMap<>();
        map.put("pending", AtsCreateOfferRequestDtoValueEnum.PENDING);
        map.put("retracted", AtsCreateOfferRequestDtoValueEnum.RETRACTED);
        map.put("accepted", AtsCreateOfferRequestDtoValueEnum.ACCEPTED);
        map.put("rejected", AtsCreateOfferRequestDtoValueEnum.REJECTED);
        map.put("created", AtsCreateOfferRequestDtoValueEnum.CREATED);
        map.put("approved", AtsCreateOfferRequestDtoValueEnum.APPROVED);
        map.put("not_approved", AtsCreateOfferRequestDtoValueEnum.NOT_APPROVED);
        map.put("unmapped_value", AtsCreateOfferRequestDtoValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AtsCreateOfferRequestDtoValue> {

        protected _Serializer() {
            super(AtsCreateOfferRequestDtoValue.class);
        }

        @Override
        public void serialize(AtsCreateOfferRequestDtoValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AtsCreateOfferRequestDtoValue> {

        protected _Deserializer() {
            super(AtsCreateOfferRequestDtoValue.class);
        }

        @Override
        public AtsCreateOfferRequestDtoValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AtsCreateOfferRequestDtoValue.of(v);
        }
    }
    
    public enum AtsCreateOfferRequestDtoValueEnum {

        PENDING("pending"),
        RETRACTED("retracted"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        CREATED("created"),
        APPROVED("approved"),
        NOT_APPROVED("not_approved"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AtsCreateOfferRequestDtoValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

