/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * CountryCode
 * 
 * <p>The country code where the bank is located
 */
public class CountryCode {
    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends HRISBankDetailsValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends HRISBankDetailsSourceValue> sourceValue;

    @JsonCreator
    public CountryCode(
            @JsonProperty("value") JsonNullable<? extends HRISBankDetailsValue> value,
            @JsonProperty("source_value") JsonNullable<? extends HRISBankDetailsSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public CountryCode() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HRISBankDetailsValue> value() {
        return (JsonNullable<HRISBankDetailsValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HRISBankDetailsSourceValue> sourceValue() {
        return (JsonNullable<HRISBankDetailsSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    public CountryCode withValue(HRISBankDetailsValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    public CountryCode withValue(JsonNullable<? extends HRISBankDetailsValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public CountryCode withSourceValue(HRISBankDetailsSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public CountryCode withSourceValue(JsonNullable<? extends HRISBankDetailsSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CountryCode other = (CountryCode) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CountryCode.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends HRISBankDetailsValue> value = JsonNullable.undefined();

        private JsonNullable<? extends HRISBankDetailsSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The ISO3166-1 Alpha2 Code of the Country
         */
        public Builder value(HRISBankDetailsValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The ISO3166-1 Alpha2 Code of the Country
         */
        public Builder value(JsonNullable<? extends HRISBankDetailsValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(HRISBankDetailsSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends HRISBankDetailsSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public CountryCode build() {

            return new CountryCode(
                value, sourceValue);
        }

    }
}
