/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * CreateEmploymentApiModelValue
 * 
 * <p>The pay period of the job postings.
 */
@JsonDeserialize(using = CreateEmploymentApiModelValue._Deserializer.class)
@JsonSerialize(using = CreateEmploymentApiModelValue._Serializer.class)
public class CreateEmploymentApiModelValue {

    public static final CreateEmploymentApiModelValue HOUR = new CreateEmploymentApiModelValue("hour");
    public static final CreateEmploymentApiModelValue DAY = new CreateEmploymentApiModelValue("day");
    public static final CreateEmploymentApiModelValue WEEK = new CreateEmploymentApiModelValue("week");
    public static final CreateEmploymentApiModelValue EVERY_TWO_WEEKS = new CreateEmploymentApiModelValue("every_two_weeks");
    public static final CreateEmploymentApiModelValue MONTH = new CreateEmploymentApiModelValue("month");
    public static final CreateEmploymentApiModelValue TWICE_A_MONTH = new CreateEmploymentApiModelValue("twice_a_month");
    public static final CreateEmploymentApiModelValue EVERY_TWO_MONTHS = new CreateEmploymentApiModelValue("every_two_months");
    public static final CreateEmploymentApiModelValue QUARTER = new CreateEmploymentApiModelValue("quarter");
    public static final CreateEmploymentApiModelValue EVERY_SIX_MONTHS = new CreateEmploymentApiModelValue("every_six_months");
    public static final CreateEmploymentApiModelValue YEAR = new CreateEmploymentApiModelValue("year");
    public static final CreateEmploymentApiModelValue ONE_OFF = new CreateEmploymentApiModelValue("one_off");
    public static final CreateEmploymentApiModelValue NONE = new CreateEmploymentApiModelValue("none");
    public static final CreateEmploymentApiModelValue UNMAPPED_VALUE = new CreateEmploymentApiModelValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CreateEmploymentApiModelValue> values = createValuesMap();
    private static final Map<String, CreateEmploymentApiModelValueEnum> enums = createEnumsMap();

    private final String value;

    private CreateEmploymentApiModelValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CreateEmploymentApiModelValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CreateEmploymentApiModelValue
     */ 
    public static CreateEmploymentApiModelValue of(String value) {
        synchronized (CreateEmploymentApiModelValue.class) {
            return values.computeIfAbsent(value, v -> new CreateEmploymentApiModelValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<CreateEmploymentApiModelValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CreateEmploymentApiModelValue other = (CreateEmploymentApiModelValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CreateEmploymentApiModelValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CreateEmploymentApiModelValue[] values() {
        synchronized (CreateEmploymentApiModelValue.class) {
            return values.values().toArray(new CreateEmploymentApiModelValue[] {});
        }
    }

    private static final Map<String, CreateEmploymentApiModelValue> createValuesMap() {
        Map<String, CreateEmploymentApiModelValue> map = new LinkedHashMap<>();
        map.put("hour", HOUR);
        map.put("day", DAY);
        map.put("week", WEEK);
        map.put("every_two_weeks", EVERY_TWO_WEEKS);
        map.put("month", MONTH);
        map.put("twice_a_month", TWICE_A_MONTH);
        map.put("every_two_months", EVERY_TWO_MONTHS);
        map.put("quarter", QUARTER);
        map.put("every_six_months", EVERY_SIX_MONTHS);
        map.put("year", YEAR);
        map.put("one_off", ONE_OFF);
        map.put("none", NONE);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, CreateEmploymentApiModelValueEnum> createEnumsMap() {
        Map<String, CreateEmploymentApiModelValueEnum> map = new HashMap<>();
        map.put("hour", CreateEmploymentApiModelValueEnum.HOUR);
        map.put("day", CreateEmploymentApiModelValueEnum.DAY);
        map.put("week", CreateEmploymentApiModelValueEnum.WEEK);
        map.put("every_two_weeks", CreateEmploymentApiModelValueEnum.EVERY_TWO_WEEKS);
        map.put("month", CreateEmploymentApiModelValueEnum.MONTH);
        map.put("twice_a_month", CreateEmploymentApiModelValueEnum.TWICE_A_MONTH);
        map.put("every_two_months", CreateEmploymentApiModelValueEnum.EVERY_TWO_MONTHS);
        map.put("quarter", CreateEmploymentApiModelValueEnum.QUARTER);
        map.put("every_six_months", CreateEmploymentApiModelValueEnum.EVERY_SIX_MONTHS);
        map.put("year", CreateEmploymentApiModelValueEnum.YEAR);
        map.put("one_off", CreateEmploymentApiModelValueEnum.ONE_OFF);
        map.put("none", CreateEmploymentApiModelValueEnum.NONE);
        map.put("unmapped_value", CreateEmploymentApiModelValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<CreateEmploymentApiModelValue> {

        protected _Serializer() {
            super(CreateEmploymentApiModelValue.class);
        }

        @Override
        public void serialize(CreateEmploymentApiModelValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<CreateEmploymentApiModelValue> {

        protected _Deserializer() {
            super(CreateEmploymentApiModelValue.class);
        }

        @Override
        public CreateEmploymentApiModelValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return CreateEmploymentApiModelValue.of(v);
        }
    }
    
    public enum CreateEmploymentApiModelValueEnum {

        HOUR("hour"),
        DAY("day"),
        WEEK("week"),
        EVERY_TWO_WEEKS("every_two_weeks"),
        MONTH("month"),
        TWICE_A_MONTH("twice_a_month"),
        EVERY_TWO_MONTHS("every_two_months"),
        QUARTER("quarter"),
        EVERY_SIX_MONTHS("every_six_months"),
        YEAR("year"),
        ONE_OFF("one_off"),
        NONE("none"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private CreateEmploymentApiModelValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

