/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * CurrencyCode
 * 
 * <p>The currency code for the account
 */
public class CurrencyCode {
    /**
     * ISO 4217 currency code
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends HRISBankDetailsCurrencyCodeValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends HRISBankDetailsCurrencyCodeSourceValue> sourceValue;

    @JsonCreator
    public CurrencyCode(
            @JsonProperty("value") JsonNullable<? extends HRISBankDetailsCurrencyCodeValue> value,
            @JsonProperty("source_value") JsonNullable<? extends HRISBankDetailsCurrencyCodeSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public CurrencyCode() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * ISO 4217 currency code
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HRISBankDetailsCurrencyCodeValue> value() {
        return (JsonNullable<HRISBankDetailsCurrencyCodeValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HRISBankDetailsCurrencyCodeSourceValue> sourceValue() {
        return (JsonNullable<HRISBankDetailsCurrencyCodeSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * ISO 4217 currency code
     */
    public CurrencyCode withValue(HRISBankDetailsCurrencyCodeValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * ISO 4217 currency code
     */
    public CurrencyCode withValue(JsonNullable<? extends HRISBankDetailsCurrencyCodeValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public CurrencyCode withSourceValue(HRISBankDetailsCurrencyCodeSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public CurrencyCode withSourceValue(JsonNullable<? extends HRISBankDetailsCurrencyCodeSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CurrencyCode other = (CurrencyCode) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(CurrencyCode.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends HRISBankDetailsCurrencyCodeValue> value = JsonNullable.undefined();

        private JsonNullable<? extends HRISBankDetailsCurrencyCodeSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * ISO 4217 currency code
         */
        public Builder value(HRISBankDetailsCurrencyCodeValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * ISO 4217 currency code
         */
        public Builder value(JsonNullable<? extends HRISBankDetailsCurrencyCodeValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(HRISBankDetailsCurrencyCodeSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends HRISBankDetailsCurrencyCodeSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public CurrencyCode build() {

            return new CurrencyCode(
                value, sourceValue);
        }

    }
}
