/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * FilesFileFormat
 * 
 * <p>The file format of the file
 */
public class FilesFileFormat {
    /**
     * The file format of the file, expressed as a file extension
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends FilesValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends FilesSourceValue> sourceValue;

    @JsonCreator
    public FilesFileFormat(
            @JsonProperty("value") JsonNullable<? extends FilesValue> value,
            @JsonProperty("source_value") JsonNullable<? extends FilesSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public FilesFileFormat() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The file format of the file, expressed as a file extension
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<FilesValue> value() {
        return (JsonNullable<FilesValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<FilesSourceValue> sourceValue() {
        return (JsonNullable<FilesSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The file format of the file, expressed as a file extension
     */
    public FilesFileFormat withValue(FilesValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The file format of the file, expressed as a file extension
     */
    public FilesFileFormat withValue(JsonNullable<? extends FilesValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public FilesFileFormat withSourceValue(FilesSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public FilesFileFormat withSourceValue(JsonNullable<? extends FilesSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FilesFileFormat other = (FilesFileFormat) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(FilesFileFormat.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends FilesValue> value = JsonNullable.undefined();

        private JsonNullable<? extends FilesSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The file format of the file, expressed as a file extension
         */
        public Builder value(FilesValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The file format of the file, expressed as a file extension
         */
        public Builder value(JsonNullable<? extends FilesValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(FilesSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends FilesSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public FilesFileFormat build() {

            return new FilesFileFormat(
                value, sourceValue);
        }

    }
}
