/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class HRISBankDetails {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The name of the bank account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_name")
    private JsonNullable<String> accountName;

    /**
     * Whether this is the primary bank account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("is_primary")
    private JsonNullable<? extends IsPrimary> isPrimary;

    /**
     * The country code where the bank is located
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("country_code")
    private JsonNullable<? extends CountryCode> countryCode;

    /**
     * The currency code for the account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("currency_code")
    private JsonNullable<? extends CurrencyCode> currencyCode;

    /**
     * The name of the bank
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("bank_name")
    private JsonNullable<String> bankName;

    /**
     * The type of bank account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_type")
    private JsonNullable<? extends AccountType> accountType;

    /**
     * International Bank Account Number (IBAN)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("iban")
    private JsonNullable<String> iban;

    /**
     * Local account number (used when IBAN is not available)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("local_account_number")
    private JsonNullable<String> localAccountNumber;

    /**
     * SWIFT/BIC code for international transfers
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("swift_bic")
    private JsonNullable<String> swiftBic;

    /**
     * Array of clearing codes required by the country
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("clearing_codes")
    private JsonNullable<? extends List<ClearingCode>> clearingCodes;

    @JsonCreator
    public HRISBankDetails(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("account_name") JsonNullable<String> accountName,
            @JsonProperty("is_primary") JsonNullable<? extends IsPrimary> isPrimary,
            @JsonProperty("country_code") JsonNullable<? extends CountryCode> countryCode,
            @JsonProperty("currency_code") JsonNullable<? extends CurrencyCode> currencyCode,
            @JsonProperty("bank_name") JsonNullable<String> bankName,
            @JsonProperty("account_type") JsonNullable<? extends AccountType> accountType,
            @JsonProperty("iban") JsonNullable<String> iban,
            @JsonProperty("local_account_number") JsonNullable<String> localAccountNumber,
            @JsonProperty("swift_bic") JsonNullable<String> swiftBic,
            @JsonProperty("clearing_codes") JsonNullable<? extends List<ClearingCode>> clearingCodes) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(accountName, "accountName");
        Utils.checkNotNull(isPrimary, "isPrimary");
        Utils.checkNotNull(countryCode, "countryCode");
        Utils.checkNotNull(currencyCode, "currencyCode");
        Utils.checkNotNull(bankName, "bankName");
        Utils.checkNotNull(accountType, "accountType");
        Utils.checkNotNull(iban, "iban");
        Utils.checkNotNull(localAccountNumber, "localAccountNumber");
        Utils.checkNotNull(swiftBic, "swiftBic");
        Utils.checkNotNull(clearingCodes, "clearingCodes");
        this.id = id;
        this.remoteId = remoteId;
        this.accountName = accountName;
        this.isPrimary = isPrimary;
        this.countryCode = countryCode;
        this.currencyCode = currencyCode;
        this.bankName = bankName;
        this.accountType = accountType;
        this.iban = iban;
        this.localAccountNumber = localAccountNumber;
        this.swiftBic = swiftBic;
        this.clearingCodes = clearingCodes;
    }
    
    public HRISBankDetails() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The name of the bank account
     */
    @JsonIgnore
    public JsonNullable<String> accountName() {
        return accountName;
    }

    /**
     * Whether this is the primary bank account
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IsPrimary> isPrimary() {
        return (JsonNullable<IsPrimary>) isPrimary;
    }

    /**
     * The country code where the bank is located
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CountryCode> countryCode() {
        return (JsonNullable<CountryCode>) countryCode;
    }

    /**
     * The currency code for the account
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CurrencyCode> currencyCode() {
        return (JsonNullable<CurrencyCode>) currencyCode;
    }

    /**
     * The name of the bank
     */
    @JsonIgnore
    public JsonNullable<String> bankName() {
        return bankName;
    }

    /**
     * The type of bank account
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountType> accountType() {
        return (JsonNullable<AccountType>) accountType;
    }

    /**
     * International Bank Account Number (IBAN)
     */
    @JsonIgnore
    public JsonNullable<String> iban() {
        return iban;
    }

    /**
     * Local account number (used when IBAN is not available)
     */
    @JsonIgnore
    public JsonNullable<String> localAccountNumber() {
        return localAccountNumber;
    }

    /**
     * SWIFT/BIC code for international transfers
     */
    @JsonIgnore
    public JsonNullable<String> swiftBic() {
        return swiftBic;
    }

    /**
     * Array of clearing codes required by the country
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ClearingCode>> clearingCodes() {
        return (JsonNullable<List<ClearingCode>>) clearingCodes;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public HRISBankDetails withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public HRISBankDetails withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public HRISBankDetails withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public HRISBankDetails withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The name of the bank account
     */
    public HRISBankDetails withAccountName(String accountName) {
        Utils.checkNotNull(accountName, "accountName");
        this.accountName = JsonNullable.of(accountName);
        return this;
    }

    /**
     * The name of the bank account
     */
    public HRISBankDetails withAccountName(JsonNullable<String> accountName) {
        Utils.checkNotNull(accountName, "accountName");
        this.accountName = accountName;
        return this;
    }

    /**
     * Whether this is the primary bank account
     */
    public HRISBankDetails withIsPrimary(IsPrimary isPrimary) {
        Utils.checkNotNull(isPrimary, "isPrimary");
        this.isPrimary = JsonNullable.of(isPrimary);
        return this;
    }

    /**
     * Whether this is the primary bank account
     */
    public HRISBankDetails withIsPrimary(JsonNullable<? extends IsPrimary> isPrimary) {
        Utils.checkNotNull(isPrimary, "isPrimary");
        this.isPrimary = isPrimary;
        return this;
    }

    /**
     * The country code where the bank is located
     */
    public HRISBankDetails withCountryCode(CountryCode countryCode) {
        Utils.checkNotNull(countryCode, "countryCode");
        this.countryCode = JsonNullable.of(countryCode);
        return this;
    }

    /**
     * The country code where the bank is located
     */
    public HRISBankDetails withCountryCode(JsonNullable<? extends CountryCode> countryCode) {
        Utils.checkNotNull(countryCode, "countryCode");
        this.countryCode = countryCode;
        return this;
    }

    /**
     * The currency code for the account
     */
    public HRISBankDetails withCurrencyCode(CurrencyCode currencyCode) {
        Utils.checkNotNull(currencyCode, "currencyCode");
        this.currencyCode = JsonNullable.of(currencyCode);
        return this;
    }

    /**
     * The currency code for the account
     */
    public HRISBankDetails withCurrencyCode(JsonNullable<? extends CurrencyCode> currencyCode) {
        Utils.checkNotNull(currencyCode, "currencyCode");
        this.currencyCode = currencyCode;
        return this;
    }

    /**
     * The name of the bank
     */
    public HRISBankDetails withBankName(String bankName) {
        Utils.checkNotNull(bankName, "bankName");
        this.bankName = JsonNullable.of(bankName);
        return this;
    }

    /**
     * The name of the bank
     */
    public HRISBankDetails withBankName(JsonNullable<String> bankName) {
        Utils.checkNotNull(bankName, "bankName");
        this.bankName = bankName;
        return this;
    }

    /**
     * The type of bank account
     */
    public HRISBankDetails withAccountType(AccountType accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = JsonNullable.of(accountType);
        return this;
    }

    /**
     * The type of bank account
     */
    public HRISBankDetails withAccountType(JsonNullable<? extends AccountType> accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = accountType;
        return this;
    }

    /**
     * International Bank Account Number (IBAN)
     */
    public HRISBankDetails withIban(String iban) {
        Utils.checkNotNull(iban, "iban");
        this.iban = JsonNullable.of(iban);
        return this;
    }

    /**
     * International Bank Account Number (IBAN)
     */
    public HRISBankDetails withIban(JsonNullable<String> iban) {
        Utils.checkNotNull(iban, "iban");
        this.iban = iban;
        return this;
    }

    /**
     * Local account number (used when IBAN is not available)
     */
    public HRISBankDetails withLocalAccountNumber(String localAccountNumber) {
        Utils.checkNotNull(localAccountNumber, "localAccountNumber");
        this.localAccountNumber = JsonNullable.of(localAccountNumber);
        return this;
    }

    /**
     * Local account number (used when IBAN is not available)
     */
    public HRISBankDetails withLocalAccountNumber(JsonNullable<String> localAccountNumber) {
        Utils.checkNotNull(localAccountNumber, "localAccountNumber");
        this.localAccountNumber = localAccountNumber;
        return this;
    }

    /**
     * SWIFT/BIC code for international transfers
     */
    public HRISBankDetails withSwiftBic(String swiftBic) {
        Utils.checkNotNull(swiftBic, "swiftBic");
        this.swiftBic = JsonNullable.of(swiftBic);
        return this;
    }

    /**
     * SWIFT/BIC code for international transfers
     */
    public HRISBankDetails withSwiftBic(JsonNullable<String> swiftBic) {
        Utils.checkNotNull(swiftBic, "swiftBic");
        this.swiftBic = swiftBic;
        return this;
    }

    /**
     * Array of clearing codes required by the country
     */
    public HRISBankDetails withClearingCodes(List<ClearingCode> clearingCodes) {
        Utils.checkNotNull(clearingCodes, "clearingCodes");
        this.clearingCodes = JsonNullable.of(clearingCodes);
        return this;
    }

    /**
     * Array of clearing codes required by the country
     */
    public HRISBankDetails withClearingCodes(JsonNullable<? extends List<ClearingCode>> clearingCodes) {
        Utils.checkNotNull(clearingCodes, "clearingCodes");
        this.clearingCodes = clearingCodes;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HRISBankDetails other = (HRISBankDetails) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.accountName, other.accountName) &&
            Utils.enhancedDeepEquals(this.isPrimary, other.isPrimary) &&
            Utils.enhancedDeepEquals(this.countryCode, other.countryCode) &&
            Utils.enhancedDeepEquals(this.currencyCode, other.currencyCode) &&
            Utils.enhancedDeepEquals(this.bankName, other.bankName) &&
            Utils.enhancedDeepEquals(this.accountType, other.accountType) &&
            Utils.enhancedDeepEquals(this.iban, other.iban) &&
            Utils.enhancedDeepEquals(this.localAccountNumber, other.localAccountNumber) &&
            Utils.enhancedDeepEquals(this.swiftBic, other.swiftBic) &&
            Utils.enhancedDeepEquals(this.clearingCodes, other.clearingCodes);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, accountName,
            isPrimary, countryCode, currencyCode,
            bankName, accountType, iban,
            localAccountNumber, swiftBic, clearingCodes);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HRISBankDetails.class,
                "id", id,
                "remoteId", remoteId,
                "accountName", accountName,
                "isPrimary", isPrimary,
                "countryCode", countryCode,
                "currencyCode", currencyCode,
                "bankName", bankName,
                "accountType", accountType,
                "iban", iban,
                "localAccountNumber", localAccountNumber,
                "swiftBic", swiftBic,
                "clearingCodes", clearingCodes);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> accountName = JsonNullable.undefined();

        private JsonNullable<? extends IsPrimary> isPrimary = JsonNullable.undefined();

        private JsonNullable<? extends CountryCode> countryCode = JsonNullable.undefined();

        private JsonNullable<? extends CurrencyCode> currencyCode = JsonNullable.undefined();

        private JsonNullable<String> bankName = JsonNullable.undefined();

        private JsonNullable<? extends AccountType> accountType = JsonNullable.undefined();

        private JsonNullable<String> iban = JsonNullable.undefined();

        private JsonNullable<String> localAccountNumber = JsonNullable.undefined();

        private JsonNullable<String> swiftBic = JsonNullable.undefined();

        private JsonNullable<? extends List<ClearingCode>> clearingCodes = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The name of the bank account
         */
        public Builder accountName(String accountName) {
            Utils.checkNotNull(accountName, "accountName");
            this.accountName = JsonNullable.of(accountName);
            return this;
        }

        /**
         * The name of the bank account
         */
        public Builder accountName(JsonNullable<String> accountName) {
            Utils.checkNotNull(accountName, "accountName");
            this.accountName = accountName;
            return this;
        }


        /**
         * Whether this is the primary bank account
         */
        public Builder isPrimary(IsPrimary isPrimary) {
            Utils.checkNotNull(isPrimary, "isPrimary");
            this.isPrimary = JsonNullable.of(isPrimary);
            return this;
        }

        /**
         * Whether this is the primary bank account
         */
        public Builder isPrimary(JsonNullable<? extends IsPrimary> isPrimary) {
            Utils.checkNotNull(isPrimary, "isPrimary");
            this.isPrimary = isPrimary;
            return this;
        }


        /**
         * The country code where the bank is located
         */
        public Builder countryCode(CountryCode countryCode) {
            Utils.checkNotNull(countryCode, "countryCode");
            this.countryCode = JsonNullable.of(countryCode);
            return this;
        }

        /**
         * The country code where the bank is located
         */
        public Builder countryCode(JsonNullable<? extends CountryCode> countryCode) {
            Utils.checkNotNull(countryCode, "countryCode");
            this.countryCode = countryCode;
            return this;
        }


        /**
         * The currency code for the account
         */
        public Builder currencyCode(CurrencyCode currencyCode) {
            Utils.checkNotNull(currencyCode, "currencyCode");
            this.currencyCode = JsonNullable.of(currencyCode);
            return this;
        }

        /**
         * The currency code for the account
         */
        public Builder currencyCode(JsonNullable<? extends CurrencyCode> currencyCode) {
            Utils.checkNotNull(currencyCode, "currencyCode");
            this.currencyCode = currencyCode;
            return this;
        }


        /**
         * The name of the bank
         */
        public Builder bankName(String bankName) {
            Utils.checkNotNull(bankName, "bankName");
            this.bankName = JsonNullable.of(bankName);
            return this;
        }

        /**
         * The name of the bank
         */
        public Builder bankName(JsonNullable<String> bankName) {
            Utils.checkNotNull(bankName, "bankName");
            this.bankName = bankName;
            return this;
        }


        /**
         * The type of bank account
         */
        public Builder accountType(AccountType accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = JsonNullable.of(accountType);
            return this;
        }

        /**
         * The type of bank account
         */
        public Builder accountType(JsonNullable<? extends AccountType> accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = accountType;
            return this;
        }


        /**
         * International Bank Account Number (IBAN)
         */
        public Builder iban(String iban) {
            Utils.checkNotNull(iban, "iban");
            this.iban = JsonNullable.of(iban);
            return this;
        }

        /**
         * International Bank Account Number (IBAN)
         */
        public Builder iban(JsonNullable<String> iban) {
            Utils.checkNotNull(iban, "iban");
            this.iban = iban;
            return this;
        }


        /**
         * Local account number (used when IBAN is not available)
         */
        public Builder localAccountNumber(String localAccountNumber) {
            Utils.checkNotNull(localAccountNumber, "localAccountNumber");
            this.localAccountNumber = JsonNullable.of(localAccountNumber);
            return this;
        }

        /**
         * Local account number (used when IBAN is not available)
         */
        public Builder localAccountNumber(JsonNullable<String> localAccountNumber) {
            Utils.checkNotNull(localAccountNumber, "localAccountNumber");
            this.localAccountNumber = localAccountNumber;
            return this;
        }


        /**
         * SWIFT/BIC code for international transfers
         */
        public Builder swiftBic(String swiftBic) {
            Utils.checkNotNull(swiftBic, "swiftBic");
            this.swiftBic = JsonNullable.of(swiftBic);
            return this;
        }

        /**
         * SWIFT/BIC code for international transfers
         */
        public Builder swiftBic(JsonNullable<String> swiftBic) {
            Utils.checkNotNull(swiftBic, "swiftBic");
            this.swiftBic = swiftBic;
            return this;
        }


        /**
         * Array of clearing codes required by the country
         */
        public Builder clearingCodes(List<ClearingCode> clearingCodes) {
            Utils.checkNotNull(clearingCodes, "clearingCodes");
            this.clearingCodes = JsonNullable.of(clearingCodes);
            return this;
        }

        /**
         * Array of clearing codes required by the country
         */
        public Builder clearingCodes(JsonNullable<? extends List<ClearingCode>> clearingCodes) {
            Utils.checkNotNull(clearingCodes, "clearingCodes");
            this.clearingCodes = clearingCodes;
            return this;
        }

        public HRISBankDetails build() {

            return new HRISBankDetails(
                id, remoteId, accountName,
                isPrimary, countryCode, currencyCode,
                bankName, accountType, iban,
                localAccountNumber, swiftBic, clearingCodes);
        }

    }
}
