/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class HrisShift {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The employee ID associated with this shift
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employee_id")
    private JsonNullable<String> employeeId;

    /**
     * The location ID where this shift takes place
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("location_id")
    private JsonNullable<String> locationId;

    /**
     * The company ID associated with this shift
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("company_id")
    private JsonNullable<String> companyId;

    /**
     * The start time of the shift (ISO8601 date-time without timezone)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_time")
    private JsonNullable<String> startTime;

    /**
     * The end time of the shift (ISO8601 date-time without timezone)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_time")
    private JsonNullable<String> endTime;

    /**
     * The total break duration for this shift in ISO 8601 duration format
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("break_duration")
    private JsonNullable<String> breakDuration;

    /**
     * The status of the shift
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends HrisShiftStatus> status;

    /**
     * The approval status of the shift
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("approval_status")
    private JsonNullable<? extends ApprovalStatus> approvalStatus;

    /**
     * The breaks taken during this shift
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("breaks")
    private JsonNullable<? extends List<ShiftBreak>> breaks;

    /**
     * The date and time the shift was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The date and time the shift was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public HrisShift(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("employee_id") JsonNullable<String> employeeId,
            @JsonProperty("location_id") JsonNullable<String> locationId,
            @JsonProperty("company_id") JsonNullable<String> companyId,
            @JsonProperty("start_time") JsonNullable<String> startTime,
            @JsonProperty("end_time") JsonNullable<String> endTime,
            @JsonProperty("break_duration") JsonNullable<String> breakDuration,
            @JsonProperty("status") JsonNullable<? extends HrisShiftStatus> status,
            @JsonProperty("approval_status") JsonNullable<? extends ApprovalStatus> approvalStatus,
            @JsonProperty("breaks") JsonNullable<? extends List<ShiftBreak>> breaks,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(locationId, "locationId");
        Utils.checkNotNull(companyId, "companyId");
        Utils.checkNotNull(startTime, "startTime");
        Utils.checkNotNull(endTime, "endTime");
        Utils.checkNotNull(breakDuration, "breakDuration");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(approvalStatus, "approvalStatus");
        Utils.checkNotNull(breaks, "breaks");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.employeeId = employeeId;
        this.locationId = locationId;
        this.companyId = companyId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.breakDuration = breakDuration;
        this.status = status;
        this.approvalStatus = approvalStatus;
        this.breaks = breaks;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public HrisShift() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The employee ID associated with this shift
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * The location ID where this shift takes place
     */
    @JsonIgnore
    public JsonNullable<String> locationId() {
        return locationId;
    }

    /**
     * The company ID associated with this shift
     */
    @JsonIgnore
    public JsonNullable<String> companyId() {
        return companyId;
    }

    /**
     * The start time of the shift (ISO8601 date-time without timezone)
     */
    @JsonIgnore
    public JsonNullable<String> startTime() {
        return startTime;
    }

    /**
     * The end time of the shift (ISO8601 date-time without timezone)
     */
    @JsonIgnore
    public JsonNullable<String> endTime() {
        return endTime;
    }

    /**
     * The total break duration for this shift in ISO 8601 duration format
     */
    @JsonIgnore
    public JsonNullable<String> breakDuration() {
        return breakDuration;
    }

    /**
     * The status of the shift
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisShiftStatus> status() {
        return (JsonNullable<HrisShiftStatus>) status;
    }

    /**
     * The approval status of the shift
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApprovalStatus> approvalStatus() {
        return (JsonNullable<ApprovalStatus>) approvalStatus;
    }

    /**
     * The breaks taken during this shift
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ShiftBreak>> breaks() {
        return (JsonNullable<List<ShiftBreak>>) breaks;
    }

    /**
     * The date and time the shift was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The date and time the shift was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public HrisShift withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public HrisShift withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public HrisShift withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public HrisShift withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The employee ID associated with this shift
     */
    public HrisShift withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * The employee ID associated with this shift
     */
    public HrisShift withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * The location ID where this shift takes place
     */
    public HrisShift withLocationId(String locationId) {
        Utils.checkNotNull(locationId, "locationId");
        this.locationId = JsonNullable.of(locationId);
        return this;
    }

    /**
     * The location ID where this shift takes place
     */
    public HrisShift withLocationId(JsonNullable<String> locationId) {
        Utils.checkNotNull(locationId, "locationId");
        this.locationId = locationId;
        return this;
    }

    /**
     * The company ID associated with this shift
     */
    public HrisShift withCompanyId(String companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = JsonNullable.of(companyId);
        return this;
    }

    /**
     * The company ID associated with this shift
     */
    public HrisShift withCompanyId(JsonNullable<String> companyId) {
        Utils.checkNotNull(companyId, "companyId");
        this.companyId = companyId;
        return this;
    }

    /**
     * The start time of the shift (ISO8601 date-time without timezone)
     */
    public HrisShift withStartTime(String startTime) {
        Utils.checkNotNull(startTime, "startTime");
        this.startTime = JsonNullable.of(startTime);
        return this;
    }

    /**
     * The start time of the shift (ISO8601 date-time without timezone)
     */
    public HrisShift withStartTime(JsonNullable<String> startTime) {
        Utils.checkNotNull(startTime, "startTime");
        this.startTime = startTime;
        return this;
    }

    /**
     * The end time of the shift (ISO8601 date-time without timezone)
     */
    public HrisShift withEndTime(String endTime) {
        Utils.checkNotNull(endTime, "endTime");
        this.endTime = JsonNullable.of(endTime);
        return this;
    }

    /**
     * The end time of the shift (ISO8601 date-time without timezone)
     */
    public HrisShift withEndTime(JsonNullable<String> endTime) {
        Utils.checkNotNull(endTime, "endTime");
        this.endTime = endTime;
        return this;
    }

    /**
     * The total break duration for this shift in ISO 8601 duration format
     */
    public HrisShift withBreakDuration(String breakDuration) {
        Utils.checkNotNull(breakDuration, "breakDuration");
        this.breakDuration = JsonNullable.of(breakDuration);
        return this;
    }

    /**
     * The total break duration for this shift in ISO 8601 duration format
     */
    public HrisShift withBreakDuration(JsonNullable<String> breakDuration) {
        Utils.checkNotNull(breakDuration, "breakDuration");
        this.breakDuration = breakDuration;
        return this;
    }

    /**
     * The status of the shift
     */
    public HrisShift withStatus(HrisShiftStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status of the shift
     */
    public HrisShift withStatus(JsonNullable<? extends HrisShiftStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The approval status of the shift
     */
    public HrisShift withApprovalStatus(ApprovalStatus approvalStatus) {
        Utils.checkNotNull(approvalStatus, "approvalStatus");
        this.approvalStatus = JsonNullable.of(approvalStatus);
        return this;
    }

    /**
     * The approval status of the shift
     */
    public HrisShift withApprovalStatus(JsonNullable<? extends ApprovalStatus> approvalStatus) {
        Utils.checkNotNull(approvalStatus, "approvalStatus");
        this.approvalStatus = approvalStatus;
        return this;
    }

    /**
     * The breaks taken during this shift
     */
    public HrisShift withBreaks(List<ShiftBreak> breaks) {
        Utils.checkNotNull(breaks, "breaks");
        this.breaks = JsonNullable.of(breaks);
        return this;
    }

    /**
     * The breaks taken during this shift
     */
    public HrisShift withBreaks(JsonNullable<? extends List<ShiftBreak>> breaks) {
        Utils.checkNotNull(breaks, "breaks");
        this.breaks = breaks;
        return this;
    }

    /**
     * The date and time the shift was created
     */
    public HrisShift withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The date and time the shift was created
     */
    public HrisShift withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The date and time the shift was last updated
     */
    public HrisShift withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The date and time the shift was last updated
     */
    public HrisShift withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisShift other = (HrisShift) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.employeeId, other.employeeId) &&
            Utils.enhancedDeepEquals(this.locationId, other.locationId) &&
            Utils.enhancedDeepEquals(this.companyId, other.companyId) &&
            Utils.enhancedDeepEquals(this.startTime, other.startTime) &&
            Utils.enhancedDeepEquals(this.endTime, other.endTime) &&
            Utils.enhancedDeepEquals(this.breakDuration, other.breakDuration) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.approvalStatus, other.approvalStatus) &&
            Utils.enhancedDeepEquals(this.breaks, other.breaks) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, employeeId,
            locationId, companyId, startTime,
            endTime, breakDuration, status,
            approvalStatus, breaks, createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisShift.class,
                "id", id,
                "remoteId", remoteId,
                "employeeId", employeeId,
                "locationId", locationId,
                "companyId", companyId,
                "startTime", startTime,
                "endTime", endTime,
                "breakDuration", breakDuration,
                "status", status,
                "approvalStatus", approvalStatus,
                "breaks", breaks,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> employeeId = JsonNullable.undefined();

        private JsonNullable<String> locationId = JsonNullable.undefined();

        private JsonNullable<String> companyId = JsonNullable.undefined();

        private JsonNullable<String> startTime = JsonNullable.undefined();

        private JsonNullable<String> endTime = JsonNullable.undefined();

        private JsonNullable<String> breakDuration = JsonNullable.undefined();

        private JsonNullable<? extends HrisShiftStatus> status = JsonNullable.undefined();

        private JsonNullable<? extends ApprovalStatus> approvalStatus = JsonNullable.undefined();

        private JsonNullable<? extends List<ShiftBreak>> breaks = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The employee ID associated with this shift
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * The employee ID associated with this shift
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }


        /**
         * The location ID where this shift takes place
         */
        public Builder locationId(String locationId) {
            Utils.checkNotNull(locationId, "locationId");
            this.locationId = JsonNullable.of(locationId);
            return this;
        }

        /**
         * The location ID where this shift takes place
         */
        public Builder locationId(JsonNullable<String> locationId) {
            Utils.checkNotNull(locationId, "locationId");
            this.locationId = locationId;
            return this;
        }


        /**
         * The company ID associated with this shift
         */
        public Builder companyId(String companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = JsonNullable.of(companyId);
            return this;
        }

        /**
         * The company ID associated with this shift
         */
        public Builder companyId(JsonNullable<String> companyId) {
            Utils.checkNotNull(companyId, "companyId");
            this.companyId = companyId;
            return this;
        }


        /**
         * The start time of the shift (ISO8601 date-time without timezone)
         */
        public Builder startTime(String startTime) {
            Utils.checkNotNull(startTime, "startTime");
            this.startTime = JsonNullable.of(startTime);
            return this;
        }

        /**
         * The start time of the shift (ISO8601 date-time without timezone)
         */
        public Builder startTime(JsonNullable<String> startTime) {
            Utils.checkNotNull(startTime, "startTime");
            this.startTime = startTime;
            return this;
        }


        /**
         * The end time of the shift (ISO8601 date-time without timezone)
         */
        public Builder endTime(String endTime) {
            Utils.checkNotNull(endTime, "endTime");
            this.endTime = JsonNullable.of(endTime);
            return this;
        }

        /**
         * The end time of the shift (ISO8601 date-time without timezone)
         */
        public Builder endTime(JsonNullable<String> endTime) {
            Utils.checkNotNull(endTime, "endTime");
            this.endTime = endTime;
            return this;
        }


        /**
         * The total break duration for this shift in ISO 8601 duration format
         */
        public Builder breakDuration(String breakDuration) {
            Utils.checkNotNull(breakDuration, "breakDuration");
            this.breakDuration = JsonNullable.of(breakDuration);
            return this;
        }

        /**
         * The total break duration for this shift in ISO 8601 duration format
         */
        public Builder breakDuration(JsonNullable<String> breakDuration) {
            Utils.checkNotNull(breakDuration, "breakDuration");
            this.breakDuration = breakDuration;
            return this;
        }


        /**
         * The status of the shift
         */
        public Builder status(HrisShiftStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status of the shift
         */
        public Builder status(JsonNullable<? extends HrisShiftStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The approval status of the shift
         */
        public Builder approvalStatus(ApprovalStatus approvalStatus) {
            Utils.checkNotNull(approvalStatus, "approvalStatus");
            this.approvalStatus = JsonNullable.of(approvalStatus);
            return this;
        }

        /**
         * The approval status of the shift
         */
        public Builder approvalStatus(JsonNullable<? extends ApprovalStatus> approvalStatus) {
            Utils.checkNotNull(approvalStatus, "approvalStatus");
            this.approvalStatus = approvalStatus;
            return this;
        }


        /**
         * The breaks taken during this shift
         */
        public Builder breaks(List<ShiftBreak> breaks) {
            Utils.checkNotNull(breaks, "breaks");
            this.breaks = JsonNullable.of(breaks);
            return this;
        }

        /**
         * The breaks taken during this shift
         */
        public Builder breaks(JsonNullable<? extends List<ShiftBreak>> breaks) {
            Utils.checkNotNull(breaks, "breaks");
            this.breaks = breaks;
            return this;
        }


        /**
         * The date and time the shift was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The date and time the shift was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The date and time the shift was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The date and time the shift was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public HrisShift build() {

            return new HrisShift(
                id, remoteId, employeeId,
                locationId, companyId, startTime,
                endTime, breakDuration, status,
                approvalStatus, breaks, createdAt,
                updatedAt);
        }

    }
}
