/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * JobStatus
 * 
 * <p>Status of the job
 */
public class JobStatus {
    /**
     * The status of the job.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AtsJobValue> value;

    /**
     * The source value of the job status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends AtsJobSourceValue> sourceValue;

    @JsonCreator
    public JobStatus(
            @JsonProperty("value") JsonNullable<? extends AtsJobValue> value,
            @JsonProperty("source_value") JsonNullable<? extends AtsJobSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public JobStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The status of the job.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsJobValue> value() {
        return (JsonNullable<AtsJobValue>) value;
    }

    /**
     * The source value of the job status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsJobSourceValue> sourceValue() {
        return (JsonNullable<AtsJobSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The status of the job.
     */
    public JobStatus withValue(AtsJobValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The status of the job.
     */
    public JobStatus withValue(JsonNullable<? extends AtsJobValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the job status.
     */
    public JobStatus withSourceValue(AtsJobSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the job status.
     */
    public JobStatus withSourceValue(JsonNullable<? extends AtsJobSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JobStatus other = (JobStatus) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(JobStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends AtsJobValue> value = JsonNullable.undefined();

        private JsonNullable<? extends AtsJobSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The status of the job.
         */
        public Builder value(AtsJobValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The status of the job.
         */
        public Builder value(JsonNullable<? extends AtsJobValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the job status.
         */
        public Builder sourceValue(AtsJobSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the job status.
         */
        public Builder sourceValue(JsonNullable<? extends AtsJobSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public JobStatus build() {

            return new JobStatus(
                value, sourceValue);
        }

    }
}
