/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;


public class MessagingMessageSendRequestDto {
    /**
     * Content body of the message
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content")
    private JsonNullable<String> content;

    /**
     * Can be a conversation ID, user ID, email or phone number.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("recipient")
    private JsonNullable<String> recipient;

    /**
     * The account_id or phone number of the message sender
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sender")
    private JsonNullable<String> sender;

    @JsonCreator
    public MessagingMessageSendRequestDto(
            @JsonProperty("content") JsonNullable<String> content,
            @JsonProperty("recipient") JsonNullable<String> recipient,
            @JsonProperty("sender") JsonNullable<String> sender) {
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(recipient, "recipient");
        Utils.checkNotNull(sender, "sender");
        this.content = content;
        this.recipient = recipient;
        this.sender = sender;
    }
    
    public MessagingMessageSendRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Content body of the message
     */
    @JsonIgnore
    public JsonNullable<String> content() {
        return content;
    }

    /**
     * Can be a conversation ID, user ID, email or phone number.
     */
    @JsonIgnore
    public JsonNullable<String> recipient() {
        return recipient;
    }

    /**
     * The account_id or phone number of the message sender
     */
    @JsonIgnore
    public JsonNullable<String> sender() {
        return sender;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Content body of the message
     */
    public MessagingMessageSendRequestDto withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of(content);
        return this;
    }

    /**
     * Content body of the message
     */
    public MessagingMessageSendRequestDto withContent(JsonNullable<String> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * Can be a conversation ID, user ID, email or phone number.
     */
    public MessagingMessageSendRequestDto withRecipient(String recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = JsonNullable.of(recipient);
        return this;
    }

    /**
     * Can be a conversation ID, user ID, email or phone number.
     */
    public MessagingMessageSendRequestDto withRecipient(JsonNullable<String> recipient) {
        Utils.checkNotNull(recipient, "recipient");
        this.recipient = recipient;
        return this;
    }

    /**
     * The account_id or phone number of the message sender
     */
    public MessagingMessageSendRequestDto withSender(String sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = JsonNullable.of(sender);
        return this;
    }

    /**
     * The account_id or phone number of the message sender
     */
    public MessagingMessageSendRequestDto withSender(JsonNullable<String> sender) {
        Utils.checkNotNull(sender, "sender");
        this.sender = sender;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingMessageSendRequestDto other = (MessagingMessageSendRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.content, other.content) &&
            Utils.enhancedDeepEquals(this.recipient, other.recipient) &&
            Utils.enhancedDeepEquals(this.sender, other.sender);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            content, recipient, sender);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingMessageSendRequestDto.class,
                "content", content,
                "recipient", recipient,
                "sender", sender);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> content = JsonNullable.undefined();

        private JsonNullable<String> recipient = JsonNullable.undefined();

        private JsonNullable<String> sender = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Content body of the message
         */
        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of(content);
            return this;
        }

        /**
         * Content body of the message
         */
        public Builder content(JsonNullable<String> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }


        /**
         * Can be a conversation ID, user ID, email or phone number.
         */
        public Builder recipient(String recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = JsonNullable.of(recipient);
            return this;
        }

        /**
         * Can be a conversation ID, user ID, email or phone number.
         */
        public Builder recipient(JsonNullable<String> recipient) {
            Utils.checkNotNull(recipient, "recipient");
            this.recipient = recipient;
            return this;
        }


        /**
         * The account_id or phone number of the message sender
         */
        public Builder sender(String sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = JsonNullable.of(sender);
            return this;
        }

        /**
         * The account_id or phone number of the message sender
         */
        public Builder sender(JsonNullable<String> sender) {
            Utils.checkNotNull(sender, "sender");
            this.sender = sender;
            return this;
        }

        public MessagingMessageSendRequestDto build() {

            return new MessagingMessageSendRequestDto(
                content, recipient, sender);
        }

    }
}
