/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * DocumentsListFilesQueryParamFilter
 * 
 * <p>Documents Files Filter
 */
public class DocumentsListFilesQueryParamFilter {
    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<OffsetDateTime> updatedAfter;

    /**
     * Search if the name of the file contains the string
     */
    @SpeakeasyMetadata("queryParam:name=name")
    private JsonNullable<String> name;

    /**
     * Search if the contents of the file contains the string (contents can include file metadata)
     */
    @SpeakeasyMetadata("queryParam:name=content")
    private JsonNullable<String> content;

    /**
     * Use a string with a date to only select results created after that given date
     */
    @SpeakeasyMetadata("queryParam:name=created_after")
    private JsonNullable<OffsetDateTime> createdAfter;

    /**
     * Use to only include Files within the specified Drive
     */
    @SpeakeasyMetadata("queryParam:name=drive_id")
    private JsonNullable<String> driveId;

    /**
     * Use to only include Files within the specified Folder. Required when requesting nested items
     */
    @SpeakeasyMetadata("queryParam:name=folder_id")
    private JsonNullable<String> folderId;

    @JsonCreator
    public DocumentsListFilesQueryParamFilter(
            JsonNullable<OffsetDateTime> updatedAfter,
            JsonNullable<String> name,
            JsonNullable<String> content,
            JsonNullable<OffsetDateTime> createdAfter,
            JsonNullable<String> driveId,
            JsonNullable<String> folderId) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(createdAfter, "createdAfter");
        Utils.checkNotNull(driveId, "driveId");
        Utils.checkNotNull(folderId, "folderId");
        this.updatedAfter = updatedAfter;
        this.name = name;
        this.content = content;
        this.createdAfter = createdAfter;
        this.driveId = driveId;
        this.folderId = folderId;
    }
    
    public DocumentsListFilesQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Search if the name of the file contains the string
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * Search if the contents of the file contains the string (contents can include file metadata)
     */
    @JsonIgnore
    public JsonNullable<String> content() {
        return content;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAfter() {
        return createdAfter;
    }

    /**
     * Use to only include Files within the specified Drive
     */
    @JsonIgnore
    public JsonNullable<String> driveId() {
        return driveId;
    }

    /**
     * Use to only include Files within the specified Folder. Required when requesting nested items
     */
    @JsonIgnore
    public JsonNullable<String> folderId() {
        return folderId;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Use a string with a date to only select results updated after that given date
     */
    public DocumentsListFilesQueryParamFilter withUpdatedAfter(OffsetDateTime updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public DocumentsListFilesQueryParamFilter withUpdatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Search if the name of the file contains the string
     */
    public DocumentsListFilesQueryParamFilter withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * Search if the name of the file contains the string
     */
    public DocumentsListFilesQueryParamFilter withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * Search if the contents of the file contains the string (contents can include file metadata)
     */
    public DocumentsListFilesQueryParamFilter withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of(content);
        return this;
    }

    /**
     * Search if the contents of the file contains the string (contents can include file metadata)
     */
    public DocumentsListFilesQueryParamFilter withContent(JsonNullable<String> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    public DocumentsListFilesQueryParamFilter withCreatedAfter(OffsetDateTime createdAfter) {
        Utils.checkNotNull(createdAfter, "createdAfter");
        this.createdAfter = JsonNullable.of(createdAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results created after that given date
     */
    public DocumentsListFilesQueryParamFilter withCreatedAfter(JsonNullable<OffsetDateTime> createdAfter) {
        Utils.checkNotNull(createdAfter, "createdAfter");
        this.createdAfter = createdAfter;
        return this;
    }

    /**
     * Use to only include Files within the specified Drive
     */
    public DocumentsListFilesQueryParamFilter withDriveId(String driveId) {
        Utils.checkNotNull(driveId, "driveId");
        this.driveId = JsonNullable.of(driveId);
        return this;
    }

    /**
     * Use to only include Files within the specified Drive
     */
    public DocumentsListFilesQueryParamFilter withDriveId(JsonNullable<String> driveId) {
        Utils.checkNotNull(driveId, "driveId");
        this.driveId = driveId;
        return this;
    }

    /**
     * Use to only include Files within the specified Folder. Required when requesting nested items
     */
    public DocumentsListFilesQueryParamFilter withFolderId(String folderId) {
        Utils.checkNotNull(folderId, "folderId");
        this.folderId = JsonNullable.of(folderId);
        return this;
    }

    /**
     * Use to only include Files within the specified Folder. Required when requesting nested items
     */
    public DocumentsListFilesQueryParamFilter withFolderId(JsonNullable<String> folderId) {
        Utils.checkNotNull(folderId, "folderId");
        this.folderId = folderId;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DocumentsListFilesQueryParamFilter other = (DocumentsListFilesQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.content, other.content) &&
            Utils.enhancedDeepEquals(this.createdAfter, other.createdAfter) &&
            Utils.enhancedDeepEquals(this.driveId, other.driveId) &&
            Utils.enhancedDeepEquals(this.folderId, other.folderId);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter, name, content,
            createdAfter, driveId, folderId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(DocumentsListFilesQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "name", name,
                "content", content,
                "createdAfter", createdAfter,
                "driveId", driveId,
                "folderId", folderId);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<OffsetDateTime> updatedAfter = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> content = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAfter = JsonNullable.undefined();

        private JsonNullable<String> driveId = JsonNullable.undefined();

        private JsonNullable<String> folderId = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(OffsetDateTime updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<OffsetDateTime> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }


        /**
         * Search if the name of the file contains the string
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * Search if the name of the file contains the string
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * Search if the contents of the file contains the string (contents can include file metadata)
         */
        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of(content);
            return this;
        }

        /**
         * Search if the contents of the file contains the string (contents can include file metadata)
         */
        public Builder content(JsonNullable<String> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }


        /**
         * Use a string with a date to only select results created after that given date
         */
        public Builder createdAfter(OffsetDateTime createdAfter) {
            Utils.checkNotNull(createdAfter, "createdAfter");
            this.createdAfter = JsonNullable.of(createdAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results created after that given date
         */
        public Builder createdAfter(JsonNullable<OffsetDateTime> createdAfter) {
            Utils.checkNotNull(createdAfter, "createdAfter");
            this.createdAfter = createdAfter;
            return this;
        }


        /**
         * Use to only include Files within the specified Drive
         */
        public Builder driveId(String driveId) {
            Utils.checkNotNull(driveId, "driveId");
            this.driveId = JsonNullable.of(driveId);
            return this;
        }

        /**
         * Use to only include Files within the specified Drive
         */
        public Builder driveId(JsonNullable<String> driveId) {
            Utils.checkNotNull(driveId, "driveId");
            this.driveId = driveId;
            return this;
        }


        /**
         * Use to only include Files within the specified Folder. Required when requesting nested items
         */
        public Builder folderId(String folderId) {
            Utils.checkNotNull(folderId, "folderId");
            this.folderId = JsonNullable.of(folderId);
            return this;
        }

        /**
         * Use to only include Files within the specified Folder. Required when requesting nested items
         */
        public Builder folderId(JsonNullable<String> folderId) {
            Utils.checkNotNull(folderId, "folderId");
            this.folderId = folderId;
            return this;
        }

        public DocumentsListFilesQueryParamFilter build() {

            return new DocumentsListFilesQueryParamFilter(
                updatedAfter, name, content,
                createdAfter, driveId, folderId);
        }

    }
}
