/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ActionsRpcResponse;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class StackoneRpcActionResponse implements Response {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * Action response
     */
    private Optional<? extends ActionsRpcResponse> actionsRpcResponse;


    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneRpcActionResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends ActionsRpcResponse> actionsRpcResponse,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.actionsRpcResponse = actionsRpcResponse;
        this.headers = headers;
    }
    
    public StackoneRpcActionResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * Action response
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<ActionsRpcResponse> actionsRpcResponse() {
        return (Optional<ActionsRpcResponse>) actionsRpcResponse;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public StackoneRpcActionResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public StackoneRpcActionResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public StackoneRpcActionResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * Action response
     */
    public StackoneRpcActionResponse withActionsRpcResponse(ActionsRpcResponse actionsRpcResponse) {
        Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
        this.actionsRpcResponse = Optional.ofNullable(actionsRpcResponse);
        return this;
    }


    /**
     * Action response
     */
    public StackoneRpcActionResponse withActionsRpcResponse(Optional<? extends ActionsRpcResponse> actionsRpcResponse) {
        Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
        this.actionsRpcResponse = actionsRpcResponse;
        return this;
    }

    public StackoneRpcActionResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StackoneRpcActionResponse other = (StackoneRpcActionResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.actionsRpcResponse, other.actionsRpcResponse) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            actionsRpcResponse, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StackoneRpcActionResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "actionsRpcResponse", actionsRpcResponse,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<InputStream> rawResponse;

        private Optional<? extends ActionsRpcResponse> actionsRpcResponse = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * Action response
         */
        public Builder actionsRpcResponse(ActionsRpcResponse actionsRpcResponse) {
            Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
            this.actionsRpcResponse = Optional.ofNullable(actionsRpcResponse);
            return this;
        }

        /**
         * Action response
         */
        public Builder actionsRpcResponse(Optional<? extends ActionsRpcResponse> actionsRpcResponse) {
            Utils.checkNotNull(actionsRpcResponse, "actionsRpcResponse");
            this.actionsRpcResponse = actionsRpcResponse;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneRpcActionResponse build() {

            return new StackoneRpcActionResponse(
                contentType, statusCode, rawResponse,
                actionsRpcResponse, headers);
        }

    }
}
