/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingAccountResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class AccountingGetCompanyAccountResponse implements AsyncResponse {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<Blob> rawResponse;

    /**
     * The account with the given identifier was retrieved.
     */
    private Optional<? extends AccountingAccountResult> accountingAccountResult;


    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingGetCompanyAccountResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Optional<? extends AccountingAccountResult> accountingAccountResult,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingAccountResult = accountingAccountResult;
        this.headers = headers;
    }
    
    public AccountingGetCompanyAccountResponse(
            String contentType,
            int statusCode,
            HttpResponse<Blob> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return rawResponse;
    }

    /**
     * The account with the given identifier was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<AccountingAccountResult> accountingAccountResult() {
        return (Optional<AccountingAccountResult>) accountingAccountResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public AccountingGetCompanyAccountResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public AccountingGetCompanyAccountResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public AccountingGetCompanyAccountResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The account with the given identifier was retrieved.
     */
    public AccountingGetCompanyAccountResponse withAccountingAccountResult(AccountingAccountResult accountingAccountResult) {
        Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
        this.accountingAccountResult = Optional.ofNullable(accountingAccountResult);
        return this;
    }


    /**
     * The account with the given identifier was retrieved.
     */
    public AccountingGetCompanyAccountResponse withAccountingAccountResult(Optional<? extends AccountingAccountResult> accountingAccountResult) {
        Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
        this.accountingAccountResult = accountingAccountResult;
        return this;
    }

    public AccountingGetCompanyAccountResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountingGetCompanyAccountResponse other = (AccountingGetCompanyAccountResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.accountingAccountResult, other.accountingAccountResult) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            accountingAccountResult, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AccountingGetCompanyAccountResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "accountingAccountResult", accountingAccountResult,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<Blob> rawResponse;

        private Optional<? extends AccountingAccountResult> accountingAccountResult = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The account with the given identifier was retrieved.
         */
        public Builder accountingAccountResult(AccountingAccountResult accountingAccountResult) {
            Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
            this.accountingAccountResult = Optional.ofNullable(accountingAccountResult);
            return this;
        }

        /**
         * The account with the given identifier was retrieved.
         */
        public Builder accountingAccountResult(Optional<? extends AccountingAccountResult> accountingAccountResult) {
            Utils.checkNotNull(accountingAccountResult, "accountingAccountResult");
            this.accountingAccountResult = accountingAccountResult;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingGetCompanyAccountResponse build() {

            return new AccountingGetCompanyAccountResponse(
                contentType, statusCode, rawResponse,
                accountingAccountResult, headers);
        }

    }
}
