/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations.async;

import static com.stackone.stackone_client_java.operations.Operations.AsyncRequestOperation;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.LmsCreateContentRequestDto;
import com.stackone.stackone_client_java.models.operations.LmsUpdateContentRequest;
import com.stackone.stackone_client_java.operations.LmsUpdateContent;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.String;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class LmsUpdateContentRequestBuilder {

    private String xAccountId;
    private String id;
    private LmsCreateContentRequestDto lmsCreateContentRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers(); 

    public LmsUpdateContentRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public LmsUpdateContentRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsUpdateContentRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LmsUpdateContentRequestBuilder lmsCreateContentRequestDto(LmsCreateContentRequestDto lmsCreateContentRequestDto) {
        Utils.checkNotNull(lmsCreateContentRequestDto, "lmsCreateContentRequestDto");
        this.lmsCreateContentRequestDto = lmsCreateContentRequestDto;
        return this;
    }
                
    public LmsUpdateContentRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public LmsUpdateContentRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }


    private LmsUpdateContentRequest buildRequest() {

        LmsUpdateContentRequest request = new LmsUpdateContentRequest(xAccountId,
            id,
            lmsCreateContentRequestDto);

        return request;
    }

    public CompletableFuture<LmsUpdateContentResponse> call() {
        Optional<Options> options = Optional.of(Options.builder()
            .retryConfig(retryConfig)
            .build());

        AsyncRequestOperation<LmsUpdateContentRequest, LmsUpdateContentResponse> operation
              = new LmsUpdateContent.Async(
                                    sdkConfiguration, options, sdkConfiguration.retryScheduler(),
                                    _headers);
        LmsUpdateContentRequest request = buildRequest();

        return operation.doRequest(request)
            .thenCompose(operation::handleResponse);
    }
}
