/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils;


import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.Optional;
import java.util.UUID;

/**
 * Utility class for defining async hook interfaces.
 */
public final class AsyncHook {

    private AsyncHook() {
        // prevent instantiation
    }

    /**
     * Specifies how a request is transformed before sending.
     */
    @FunctionalInterface
    public interface BeforeRequest {

        /**
         * Transforms the given {@link HttpRequest} before sending.
         *
         * <p>Note that {@link HttpRequest} is immutable. To modify the request you can use
         * {@code HttpRequest#newBuilder(HttpRequest, BiPredicate<String, String>)} with
         * JDK 16 and later (which will copy the request for modification in a builder).
         * If that method is not available then use {@link Helpers#copy} (which also returns
         * a builder).
         *
         * @param context context for the hook call
         * @param request request to be transformed
         * @return transformed request
         */
        CompletableFuture<HttpRequest> beforeRequest(Hook.BeforeRequestContext context, HttpRequest request);

        BeforeRequest DEFAULT = (context, request) -> CompletableFuture.completedFuture(request);
    }

    /**
     * Specifies how a response is transformed before response processing.
     */
    @FunctionalInterface
    public interface AfterSuccess {

        /**
         * Transforms the given response before response processing occurs.
         *
         * @param context  context for the hook call
         * @param response response to be transformed
         * @return transformed response
         */
        CompletableFuture<HttpResponse<Blob>> afterSuccess(Hook.AfterSuccessContext context, HttpResponse<Blob> response);

        AfterSuccess DEFAULT = (context, response) ->  CompletableFuture.completedFuture(response);
    }

    /**
     * Specifies what happens if a request action throws an Exception.
     */
    @FunctionalInterface
    public interface AfterError {

        /**
         * Either returns an HttpResponse or throws an Exception. Must be passed either
         * a response or an error (both can't be absent).
         *
         * @param context  context for the error
         * @param response response information if available.
         * @param error    the optional exception. If response present then the error is for-info
         *                 only, it was the last error in the chain of AfterError hook
         *                 calls leading to this one
         * @return HTTP response if method decides that an exception is not to be thrown
         */
        CompletableFuture<HttpResponse<Blob>> afterError(
                Hook.AfterErrorContext context,
                HttpResponse<Blob> response,
                Throwable error);

        AfterError DEFAULT = (context, response, error) -> Optional.ofNullable(response)
                    .map(CompletableFuture::completedFuture)
                    .orElse(CompletableFuture.failedFuture(error));
    }

    public static final class IdempotencyHook implements BeforeRequest {

        @Override
        public CompletableFuture<HttpRequest> beforeRequest(Hook.BeforeRequestContext context, HttpRequest request) {
            HttpRequest.Builder b = Helpers.copy(request);
            b.header("Idempotency-Key", UUID.randomUUID().toString());
            return CompletableFuture.completedFuture(b.build());
        }
    }
}
