/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils.pagination;

import com.jayway.jsonpath.ReadContext;

// Internal API only

/**
 * Handles pagination using cursor values from responses.
 * This tracker is suitable for APIs that return a cursor value in each response
 * that should be used to fetch the next page.
 *
 * @param <ProgressParamT> The type of the cursor value
 */
public class CursorTracker<ProgressParamT> implements ProgressTrackerStrategy<ProgressParamT> {
    private final String cursorExpression;
    private ProgressParamT currentCursor;
    private final Class<ProgressParamT> cursorType;

    public CursorTracker(String cursorExpression, Class<ProgressParamT> cursorType) {
        this.cursorExpression = cursorExpression;
        this.cursorType = cursorType;
    }

    @Override
    public boolean advance(ReadContext respJson) {
        ProgressParamT cursor = respJson.read(cursorExpression, cursorType);
        if (cursor == null || (cursorType == String.class && ((String) cursor).trim().isEmpty())) {
            return false;
        }
        currentCursor = cursor;
        return true;
    }

    @Override
    public ProgressParamT getPosition() {
        return currentCursor;
    }
}