/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.MessagingListUsersRequest;
import com.stackone.stackone_client_java.models.operations.MessagingListUsersResponse;
import com.stackone.stackone_client_java.operations.MessagingListUsers;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class MessagingListUsersRequestBuilder {
    private MessagingListUsersRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public MessagingListUsersRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public MessagingListUsersRequestBuilder request(MessagingListUsersRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public MessagingListUsersRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public MessagingListUsersRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public MessagingListUsersResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListUsers.Sync operation = new MessagingListUsers.Sync(this.sdkConfiguration, options, this._headers);
        return (MessagingListUsersResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<MessagingListUsersResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        MessagingListUsers.Sync operation = new MessagingListUsers.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<MessagingListUsersRequest, String> iterator = new Paginator<MessagingListUsersRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), MessagingListUsersRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<MessagingListUsersResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

