/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.BatchResultApiModel;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LmsBatchUpsertContentResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends BatchResultApiModel> batchResultApiModel;
    private Map<String, List<String>> headers;

    @JsonCreator
    public LmsBatchUpsertContentResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends BatchResultApiModel> batchResultApiModel, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.batchResultApiModel = batchResultApiModel;
        this.headers = headers;
    }

    public LmsBatchUpsertContentResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<BatchResultApiModel> batchResultApiModel() {
        return this.batchResultApiModel;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LmsBatchUpsertContentResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public LmsBatchUpsertContentResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public LmsBatchUpsertContentResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public LmsBatchUpsertContentResponse withBatchResultApiModel(BatchResultApiModel batchResultApiModel) {
        Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
        this.batchResultApiModel = Optional.ofNullable(batchResultApiModel);
        return this;
    }

    public LmsBatchUpsertContentResponse withBatchResultApiModel(Optional<? extends BatchResultApiModel> batchResultApiModel) {
        Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
        this.batchResultApiModel = batchResultApiModel;
        return this;
    }

    public LmsBatchUpsertContentResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsBatchUpsertContentResponse other = (LmsBatchUpsertContentResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.batchResultApiModel, other.batchResultApiModel) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.batchResultApiModel, this.headers);
    }

    public String toString() {
        return Utils.toString(LmsBatchUpsertContentResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "batchResultApiModel", this.batchResultApiModel, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends BatchResultApiModel> batchResultApiModel = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder batchResultApiModel(BatchResultApiModel batchResultApiModel) {
            Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
            this.batchResultApiModel = Optional.ofNullable(batchResultApiModel);
            return this;
        }

        public Builder batchResultApiModel(Optional<? extends BatchResultApiModel> batchResultApiModel) {
            Utils.checkNotNull(batchResultApiModel, "batchResultApiModel");
            this.batchResultApiModel = batchResultApiModel;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public LmsBatchUpsertContentResponse build() {
            return new LmsBatchUpsertContentResponse(this.contentType, this.statusCode, this.rawResponse, this.batchResultApiModel, this.headers);
        }
    }
}

