/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.operations;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;
/**
 * LmsListUsersQueryParamFilter - LMS Users Filter
 */

public class LmsListUsersQueryParamFilter {

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<String> updatedAfter;

    /**
     * Filter to select users by email
     */
    @SpeakeasyMetadata("queryParam:name=email")
    private JsonNullable<String> email;

    /**
     * Filter to select users by external_reference
     */
    @SpeakeasyMetadata("queryParam:name=external_reference")
    private JsonNullable<String> externalReference;

    @JsonCreator
    public LmsListUsersQueryParamFilter(
            JsonNullable<String> updatedAfter,
            JsonNullable<String> email,
            JsonNullable<String> externalReference) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(externalReference, "externalReference");
        this.updatedAfter = updatedAfter;
        this.email = email;
        this.externalReference = externalReference;
    }
    
    public LmsListUsersQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<String> updatedAfter() {
        return updatedAfter;
    }

    /**
     * Filter to select users by email
     */
    @JsonIgnore
    public JsonNullable<String> email() {
        return email;
    }

    /**
     * Filter to select users by external_reference
     */
    @JsonIgnore
    public JsonNullable<String> externalReference() {
        return externalReference;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public LmsListUsersQueryParamFilter withUpdatedAfter(String updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public LmsListUsersQueryParamFilter withUpdatedAfter(JsonNullable<String> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * Filter to select users by email
     */
    public LmsListUsersQueryParamFilter withEmail(String email) {
        Utils.checkNotNull(email, "email");
        this.email = JsonNullable.of(email);
        return this;
    }

    /**
     * Filter to select users by email
     */
    public LmsListUsersQueryParamFilter withEmail(JsonNullable<String> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    /**
     * Filter to select users by external_reference
     */
    public LmsListUsersQueryParamFilter withExternalReference(String externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = JsonNullable.of(externalReference);
        return this;
    }

    /**
     * Filter to select users by external_reference
     */
    public LmsListUsersQueryParamFilter withExternalReference(JsonNullable<String> externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = externalReference;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsListUsersQueryParamFilter other = (LmsListUsersQueryParamFilter) o;
        return 
            Objects.deepEquals(this.updatedAfter, other.updatedAfter) &&
            Objects.deepEquals(this.email, other.email) &&
            Objects.deepEquals(this.externalReference, other.externalReference);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            updatedAfter,
            email,
            externalReference);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsListUsersQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "email", email,
                "externalReference", externalReference);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> updatedAfter = JsonNullable.undefined();
 
        private JsonNullable<String> email = JsonNullable.undefined();
 
        private JsonNullable<String> externalReference = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(String updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<String> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }

        /**
         * Filter to select users by email
         */
        public Builder email(String email) {
            Utils.checkNotNull(email, "email");
            this.email = JsonNullable.of(email);
            return this;
        }

        /**
         * Filter to select users by email
         */
        public Builder email(JsonNullable<String> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        /**
         * Filter to select users by external_reference
         */
        public Builder externalReference(String externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = JsonNullable.of(externalReference);
            return this;
        }

        /**
         * Filter to select users by external_reference
         */
        public Builder externalReference(JsonNullable<String> externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = externalReference;
            return this;
        }
        
        public LmsListUsersQueryParamFilter build() {
            return new LmsListUsersQueryParamFilter(
                updatedAfter,
                email,
                externalReference);
        }
    }
}

