/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class ParentQuestion {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * List of parent questions's option IDs
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("option_ids")
    private JsonNullable<? extends List<String>> optionIds;

    /**
     * Provider's list of parent questions's option IDs
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_option_ids")
    private JsonNullable<? extends List<String>> remoteOptionIds;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("condition_type")
    private JsonNullable<? extends ConditionType> conditionType;

    @JsonCreator
    public ParentQuestion(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("option_ids") JsonNullable<? extends List<String>> optionIds,
            @JsonProperty("remote_option_ids") JsonNullable<? extends List<String>> remoteOptionIds,
            @JsonProperty("condition_type") JsonNullable<? extends ConditionType> conditionType) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(optionIds, "optionIds");
        Utils.checkNotNull(remoteOptionIds, "remoteOptionIds");
        Utils.checkNotNull(conditionType, "conditionType");
        this.id = id;
        this.remoteId = remoteId;
        this.optionIds = optionIds;
        this.remoteOptionIds = remoteOptionIds;
        this.conditionType = conditionType;
    }
    
    public ParentQuestion() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * List of parent questions's option IDs
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> optionIds() {
        return (JsonNullable<List<String>>) optionIds;
    }

    /**
     * Provider's list of parent questions's option IDs
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteOptionIds() {
        return (JsonNullable<List<String>>) remoteOptionIds;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ConditionType> conditionType() {
        return (JsonNullable<ConditionType>) conditionType;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public ParentQuestion withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public ParentQuestion withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public ParentQuestion withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public ParentQuestion withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * List of parent questions's option IDs
     */
    public ParentQuestion withOptionIds(List<String> optionIds) {
        Utils.checkNotNull(optionIds, "optionIds");
        this.optionIds = JsonNullable.of(optionIds);
        return this;
    }

    /**
     * List of parent questions's option IDs
     */
    public ParentQuestion withOptionIds(JsonNullable<? extends List<String>> optionIds) {
        Utils.checkNotNull(optionIds, "optionIds");
        this.optionIds = optionIds;
        return this;
    }

    /**
     * Provider's list of parent questions's option IDs
     */
    public ParentQuestion withRemoteOptionIds(List<String> remoteOptionIds) {
        Utils.checkNotNull(remoteOptionIds, "remoteOptionIds");
        this.remoteOptionIds = JsonNullable.of(remoteOptionIds);
        return this;
    }

    /**
     * Provider's list of parent questions's option IDs
     */
    public ParentQuestion withRemoteOptionIds(JsonNullable<? extends List<String>> remoteOptionIds) {
        Utils.checkNotNull(remoteOptionIds, "remoteOptionIds");
        this.remoteOptionIds = remoteOptionIds;
        return this;
    }

    public ParentQuestion withConditionType(ConditionType conditionType) {
        Utils.checkNotNull(conditionType, "conditionType");
        this.conditionType = JsonNullable.of(conditionType);
        return this;
    }

    public ParentQuestion withConditionType(JsonNullable<? extends ConditionType> conditionType) {
        Utils.checkNotNull(conditionType, "conditionType");
        this.conditionType = conditionType;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ParentQuestion other = (ParentQuestion) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.optionIds, other.optionIds) &&
            Objects.deepEquals(this.remoteOptionIds, other.remoteOptionIds) &&
            Objects.deepEquals(this.conditionType, other.conditionType);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            optionIds,
            remoteOptionIds,
            conditionType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ParentQuestion.class,
                "id", id,
                "remoteId", remoteId,
                "optionIds", optionIds,
                "remoteOptionIds", remoteOptionIds,
                "conditionType", conditionType);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> optionIds = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> remoteOptionIds = JsonNullable.undefined();
 
        private JsonNullable<? extends ConditionType> conditionType = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * List of parent questions's option IDs
         */
        public Builder optionIds(List<String> optionIds) {
            Utils.checkNotNull(optionIds, "optionIds");
            this.optionIds = JsonNullable.of(optionIds);
            return this;
        }

        /**
         * List of parent questions's option IDs
         */
        public Builder optionIds(JsonNullable<? extends List<String>> optionIds) {
            Utils.checkNotNull(optionIds, "optionIds");
            this.optionIds = optionIds;
            return this;
        }

        /**
         * Provider's list of parent questions's option IDs
         */
        public Builder remoteOptionIds(List<String> remoteOptionIds) {
            Utils.checkNotNull(remoteOptionIds, "remoteOptionIds");
            this.remoteOptionIds = JsonNullable.of(remoteOptionIds);
            return this;
        }

        /**
         * Provider's list of parent questions's option IDs
         */
        public Builder remoteOptionIds(JsonNullable<? extends List<String>> remoteOptionIds) {
            Utils.checkNotNull(remoteOptionIds, "remoteOptionIds");
            this.remoteOptionIds = remoteOptionIds;
            return this;
        }

        public Builder conditionType(ConditionType conditionType) {
            Utils.checkNotNull(conditionType, "conditionType");
            this.conditionType = JsonNullable.of(conditionType);
            return this;
        }

        public Builder conditionType(JsonNullable<? extends ConditionType> conditionType) {
            Utils.checkNotNull(conditionType, "conditionType");
            this.conditionType = conditionType;
            return this;
        }
        
        public ParentQuestion build() {
            return new ParentQuestion(
                id,
                remoteId,
                optionIds,
                remoteOptionIds,
                conditionType);
        }
    }
}
