/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * TimeOffBalancesPolicyTypeValue
 * 
 * <p>The unified value for the type of the time off policy. If the provider does not specify this unit, the value will be set to unmapped_value
 */
@JsonDeserialize(using = TimeOffBalancesPolicyTypeValue._Deserializer.class)
@JsonSerialize(using = TimeOffBalancesPolicyTypeValue._Serializer.class)
public class TimeOffBalancesPolicyTypeValue {

    public static final TimeOffBalancesPolicyTypeValue PAID = new TimeOffBalancesPolicyTypeValue("paid");
    public static final TimeOffBalancesPolicyTypeValue UNPAID = new TimeOffBalancesPolicyTypeValue("unpaid");
    public static final TimeOffBalancesPolicyTypeValue HOLIDAY = new TimeOffBalancesPolicyTypeValue("holiday");
    public static final TimeOffBalancesPolicyTypeValue VACATION = new TimeOffBalancesPolicyTypeValue("vacation");
    public static final TimeOffBalancesPolicyTypeValue SICK = new TimeOffBalancesPolicyTypeValue("sick");
    public static final TimeOffBalancesPolicyTypeValue PERSONAL = new TimeOffBalancesPolicyTypeValue("personal");
    public static final TimeOffBalancesPolicyTypeValue IN_LIEU = new TimeOffBalancesPolicyTypeValue("in_lieu");
    public static final TimeOffBalancesPolicyTypeValue BEREAVEMENT = new TimeOffBalancesPolicyTypeValue("bereavement");
    public static final TimeOffBalancesPolicyTypeValue JURY_DUTY = new TimeOffBalancesPolicyTypeValue("jury_duty");
    public static final TimeOffBalancesPolicyTypeValue UNMAPPED_VALUE = new TimeOffBalancesPolicyTypeValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, TimeOffBalancesPolicyTypeValue> values = createValuesMap();
    private static final Map<String, TimeOffBalancesPolicyTypeValueEnum> enums = createEnumsMap();

    private final String value;

    private TimeOffBalancesPolicyTypeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a TimeOffBalancesPolicyTypeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as TimeOffBalancesPolicyTypeValue
     */ 
    public static TimeOffBalancesPolicyTypeValue of(String value) {
        synchronized (TimeOffBalancesPolicyTypeValue.class) {
            return values.computeIfAbsent(value, v -> new TimeOffBalancesPolicyTypeValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<TimeOffBalancesPolicyTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TimeOffBalancesPolicyTypeValue other = (TimeOffBalancesPolicyTypeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "TimeOffBalancesPolicyTypeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static TimeOffBalancesPolicyTypeValue[] values() {
        synchronized (TimeOffBalancesPolicyTypeValue.class) {
            return values.values().toArray(new TimeOffBalancesPolicyTypeValue[] {});
        }
    }

    private static final Map<String, TimeOffBalancesPolicyTypeValue> createValuesMap() {
        Map<String, TimeOffBalancesPolicyTypeValue> map = new LinkedHashMap<>();
        map.put("paid", PAID);
        map.put("unpaid", UNPAID);
        map.put("holiday", HOLIDAY);
        map.put("vacation", VACATION);
        map.put("sick", SICK);
        map.put("personal", PERSONAL);
        map.put("in_lieu", IN_LIEU);
        map.put("bereavement", BEREAVEMENT);
        map.put("jury_duty", JURY_DUTY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, TimeOffBalancesPolicyTypeValueEnum> createEnumsMap() {
        Map<String, TimeOffBalancesPolicyTypeValueEnum> map = new HashMap<>();
        map.put("paid", TimeOffBalancesPolicyTypeValueEnum.PAID);
        map.put("unpaid", TimeOffBalancesPolicyTypeValueEnum.UNPAID);
        map.put("holiday", TimeOffBalancesPolicyTypeValueEnum.HOLIDAY);
        map.put("vacation", TimeOffBalancesPolicyTypeValueEnum.VACATION);
        map.put("sick", TimeOffBalancesPolicyTypeValueEnum.SICK);
        map.put("personal", TimeOffBalancesPolicyTypeValueEnum.PERSONAL);
        map.put("in_lieu", TimeOffBalancesPolicyTypeValueEnum.IN_LIEU);
        map.put("bereavement", TimeOffBalancesPolicyTypeValueEnum.BEREAVEMENT);
        map.put("jury_duty", TimeOffBalancesPolicyTypeValueEnum.JURY_DUTY);
        map.put("unmapped_value", TimeOffBalancesPolicyTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<TimeOffBalancesPolicyTypeValue> {

        protected _Serializer() {
            super(TimeOffBalancesPolicyTypeValue.class);
        }

        @Override
        public void serialize(TimeOffBalancesPolicyTypeValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<TimeOffBalancesPolicyTypeValue> {

        protected _Deserializer() {
            super(TimeOffBalancesPolicyTypeValue.class);
        }

        @Override
        public TimeOffBalancesPolicyTypeValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return TimeOffBalancesPolicyTypeValue.of(v);
        }
    }
    
    public enum TimeOffBalancesPolicyTypeValueEnum {

        PAID("paid"),
        UNPAID("unpaid"),
        HOLIDAY("holiday"),
        VACATION("vacation"),
        SICK("sick"),
        PERSONAL("personal"),
        IN_LIEU("in_lieu"),
        BEREAVEMENT("bereavement"),
        JURY_DUTY("jury_duty"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private TimeOffBalancesPolicyTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

