/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MarketingCreateContentBlocksRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class MarketingCreateContentBlockRequest {

    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    @SpeakeasyMetadata("request:mediaType=application/json")
    private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;

    @JsonCreator
    public MarketingCreateContentBlockRequest(
            String xAccountId,
            MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.xAccountId = xAccountId;
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto() {
        return marketingCreateContentBlocksRequestDto;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The account identifier
     */
    public MarketingCreateContentBlockRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public MarketingCreateContentBlockRequest withMarketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
        Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
        this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MarketingCreateContentBlockRequest other = (MarketingCreateContentBlockRequest) o;
        return 
            Objects.deepEquals(this.xAccountId, other.xAccountId) &&
            Objects.deepEquals(this.marketingCreateContentBlocksRequestDto, other.marketingCreateContentBlocksRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xAccountId,
            marketingCreateContentBlocksRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MarketingCreateContentBlockRequest.class,
                "xAccountId", xAccountId,
                "marketingCreateContentBlocksRequestDto", marketingCreateContentBlocksRequestDto);
    }
    
    public final static class Builder {
 
        private String xAccountId;
 
        private MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder marketingCreateContentBlocksRequestDto(MarketingCreateContentBlocksRequestDto marketingCreateContentBlocksRequestDto) {
            Utils.checkNotNull(marketingCreateContentBlocksRequestDto, "marketingCreateContentBlocksRequestDto");
            this.marketingCreateContentBlocksRequestDto = marketingCreateContentBlocksRequestDto;
            return this;
        }
        
        public MarketingCreateContentBlockRequest build() {
            return new MarketingCreateContentBlockRequest(
                xAccountId,
                marketingCreateContentBlocksRequestDto);
        }
    }
}
