/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisListEmployeeTimeOffBalancesQueryParamFilter
 * 
 * <p>HRIS Time Off Balance filters
 */
public class HrisListEmployeeTimeOffBalancesQueryParamFilter {

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<String> updatedAfter;

    /**
     * List of policy ids to filter time off balances by.
     */
    @SpeakeasyMetadata("queryParam:name=policy_ids")
    private JsonNullable<? extends List<String>> policyIds;

    @JsonCreator
    public HrisListEmployeeTimeOffBalancesQueryParamFilter(
            JsonNullable<String> updatedAfter,
            JsonNullable<? extends List<String>> policyIds) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(policyIds, "policyIds");
        this.updatedAfter = updatedAfter;
        this.policyIds = policyIds;
    }
    
    public HrisListEmployeeTimeOffBalancesQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<String> updatedAfter() {
        return updatedAfter;
    }

    /**
     * List of policy ids to filter time off balances by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> policyIds() {
        return (JsonNullable<List<String>>) policyIds;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListEmployeeTimeOffBalancesQueryParamFilter withUpdatedAfter(String updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListEmployeeTimeOffBalancesQueryParamFilter withUpdatedAfter(JsonNullable<String> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * List of policy ids to filter time off balances by.
     */
    public HrisListEmployeeTimeOffBalancesQueryParamFilter withPolicyIds(List<String> policyIds) {
        Utils.checkNotNull(policyIds, "policyIds");
        this.policyIds = JsonNullable.of(policyIds);
        return this;
    }

    /**
     * List of policy ids to filter time off balances by.
     */
    public HrisListEmployeeTimeOffBalancesQueryParamFilter withPolicyIds(JsonNullable<? extends List<String>> policyIds) {
        Utils.checkNotNull(policyIds, "policyIds");
        this.policyIds = policyIds;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeTimeOffBalancesQueryParamFilter other = (HrisListEmployeeTimeOffBalancesQueryParamFilter) o;
        return 
            Objects.deepEquals(this.updatedAfter, other.updatedAfter) &&
            Objects.deepEquals(this.policyIds, other.policyIds);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            updatedAfter,
            policyIds);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListEmployeeTimeOffBalancesQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "policyIds", policyIds);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> updatedAfter = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> policyIds = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(String updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<String> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }

        /**
         * List of policy ids to filter time off balances by.
         */
        public Builder policyIds(List<String> policyIds) {
            Utils.checkNotNull(policyIds, "policyIds");
            this.policyIds = JsonNullable.of(policyIds);
            return this;
        }

        /**
         * List of policy ids to filter time off balances by.
         */
        public Builder policyIds(JsonNullable<? extends List<String>> policyIds) {
            Utils.checkNotNull(policyIds, "policyIds");
            this.policyIds = policyIds;
            return this;
        }
        
        public HrisListEmployeeTimeOffBalancesQueryParamFilter build() {
            return new HrisListEmployeeTimeOffBalancesQueryParamFilter(
                updatedAfter,
                policyIds);
        }
    }
}
