/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisUpdateEmploymentRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class HrisUpdateEmployeeEmploymentRequest {

    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;

    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;

    @SpeakeasyMetadata("request:mediaType=application/json")
    private HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto;

    @JsonCreator
    public HrisUpdateEmployeeEmploymentRequest(
            String xAccountId,
            String id,
            String subResourceId,
            HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        Utils.checkNotNull(hrisUpdateEmploymentRequestDto, "hrisUpdateEmploymentRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.subResourceId = subResourceId;
        this.hrisUpdateEmploymentRequestDto = hrisUpdateEmploymentRequestDto;
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public String subResourceId() {
        return subResourceId;
    }

    @JsonIgnore
    public HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto() {
        return hrisUpdateEmploymentRequestDto;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The account identifier
     */
    public HrisUpdateEmployeeEmploymentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisUpdateEmployeeEmploymentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisUpdateEmployeeEmploymentRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    public HrisUpdateEmployeeEmploymentRequest withHrisUpdateEmploymentRequestDto(HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto) {
        Utils.checkNotNull(hrisUpdateEmploymentRequestDto, "hrisUpdateEmploymentRequestDto");
        this.hrisUpdateEmploymentRequestDto = hrisUpdateEmploymentRequestDto;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisUpdateEmployeeEmploymentRequest other = (HrisUpdateEmployeeEmploymentRequest) o;
        return 
            Objects.deepEquals(this.xAccountId, other.xAccountId) &&
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.subResourceId, other.subResourceId) &&
            Objects.deepEquals(this.hrisUpdateEmploymentRequestDto, other.hrisUpdateEmploymentRequestDto);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            xAccountId,
            id,
            subResourceId,
            hrisUpdateEmploymentRequestDto);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisUpdateEmployeeEmploymentRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "subResourceId", subResourceId,
                "hrisUpdateEmploymentRequestDto", hrisUpdateEmploymentRequestDto);
    }
    
    public final static class Builder {
 
        private String xAccountId;
 
        private String id;
 
        private String subResourceId;
 
        private HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }

        public Builder hrisUpdateEmploymentRequestDto(HrisUpdateEmploymentRequestDto hrisUpdateEmploymentRequestDto) {
            Utils.checkNotNull(hrisUpdateEmploymentRequestDto, "hrisUpdateEmploymentRequestDto");
            this.hrisUpdateEmploymentRequestDto = hrisUpdateEmploymentRequestDto;
            return this;
        }
        
        public HrisUpdateEmployeeEmploymentRequest build() {
            return new HrisUpdateEmployeeEmploymentRequest(
                xAccountId,
                id,
                subResourceId,
                hrisUpdateEmploymentRequestDto);
        }
    }
}
