/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.InAppTemplatesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class MarketingListInAppTemplatesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<MarketingListInAppTemplatesResponse>> next = () -> Optional.empty();

    @JsonCreator
    public MarketingListInAppTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.inAppTemplatesPaginated = inAppTemplatesPaginated;
        this.headers = headers;
    }

    public MarketingListInAppTemplatesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InAppTemplatesPaginated> inAppTemplatesPaginated() {
        return this.inAppTemplatesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<MarketingListInAppTemplatesResponse> next() throws Exception {
        return this.next.call();
    }

    private MarketingListInAppTemplatesResponse withNext(Callable<Optional<MarketingListInAppTemplatesResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MarketingListInAppTemplatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingListInAppTemplatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingListInAppTemplatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingListInAppTemplatesResponse withInAppTemplatesPaginated(InAppTemplatesPaginated inAppTemplatesPaginated) {
        Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
        this.inAppTemplatesPaginated = Optional.ofNullable(inAppTemplatesPaginated);
        return this;
    }

    public MarketingListInAppTemplatesResponse withInAppTemplatesPaginated(Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated) {
        Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
        this.inAppTemplatesPaginated = inAppTemplatesPaginated;
        return this;
    }

    public MarketingListInAppTemplatesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingListInAppTemplatesResponse other = (MarketingListInAppTemplatesResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.inAppTemplatesPaginated, other.inAppTemplatesPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.inAppTemplatesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingListInAppTemplatesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "inAppTemplatesPaginated", this.inAppTemplatesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<MarketingListInAppTemplatesResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder inAppTemplatesPaginated(InAppTemplatesPaginated inAppTemplatesPaginated) {
            Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
            this.inAppTemplatesPaginated = Optional.ofNullable(inAppTemplatesPaginated);
            return this;
        }

        public Builder inAppTemplatesPaginated(Optional<? extends InAppTemplatesPaginated> inAppTemplatesPaginated) {
            Utils.checkNotNull(inAppTemplatesPaginated, "inAppTemplatesPaginated");
            this.inAppTemplatesPaginated = inAppTemplatesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<MarketingListInAppTemplatesResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public MarketingListInAppTemplatesResponse build() {
            return new MarketingListInAppTemplatesResponse(this.contentType, this.statusCode, this.rawResponse, this.inAppTemplatesPaginated, this.headers).withNext(this.next);
        }
    }
}

