/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.BackgroundCheckPackagePaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListBackgroundCheckPackagesResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends BackgroundCheckPackagePaginated> backgroundCheckPackagePaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListBackgroundCheckPackagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends BackgroundCheckPackagePaginated> backgroundCheckPackagePaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(backgroundCheckPackagePaginated, "backgroundCheckPackagePaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.backgroundCheckPackagePaginated = backgroundCheckPackagePaginated;
        this.headers = headers;
    }

    public AtsListBackgroundCheckPackagesResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<BackgroundCheckPackagePaginated> backgroundCheckPackagePaginated() {
        return this.backgroundCheckPackagePaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListBackgroundCheckPackagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListBackgroundCheckPackagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListBackgroundCheckPackagesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListBackgroundCheckPackagesResponse withBackgroundCheckPackagePaginated(BackgroundCheckPackagePaginated backgroundCheckPackagePaginated) {
        Utils.checkNotNull(backgroundCheckPackagePaginated, "backgroundCheckPackagePaginated");
        this.backgroundCheckPackagePaginated = Optional.ofNullable(backgroundCheckPackagePaginated);
        return this;
    }

    public AtsListBackgroundCheckPackagesResponse withBackgroundCheckPackagePaginated(Optional<? extends BackgroundCheckPackagePaginated> backgroundCheckPackagePaginated) {
        Utils.checkNotNull(backgroundCheckPackagePaginated, "backgroundCheckPackagePaginated");
        this.backgroundCheckPackagePaginated = backgroundCheckPackagePaginated;
        return this;
    }

    public AtsListBackgroundCheckPackagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListBackgroundCheckPackagesResponse other = (AtsListBackgroundCheckPackagesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.backgroundCheckPackagePaginated, other.backgroundCheckPackagePaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.backgroundCheckPackagePaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListBackgroundCheckPackagesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "backgroundCheckPackagePaginated", this.backgroundCheckPackagePaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends BackgroundCheckPackagePaginated> backgroundCheckPackagePaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder backgroundCheckPackagePaginated(BackgroundCheckPackagePaginated backgroundCheckPackagePaginated) {
            Utils.checkNotNull(backgroundCheckPackagePaginated, "backgroundCheckPackagePaginated");
            this.backgroundCheckPackagePaginated = Optional.ofNullable(backgroundCheckPackagePaginated);
            return this;
        }

        public Builder backgroundCheckPackagePaginated(Optional<? extends BackgroundCheckPackagePaginated> backgroundCheckPackagePaginated) {
            Utils.checkNotNull(backgroundCheckPackagePaginated, "backgroundCheckPackagePaginated");
            this.backgroundCheckPackagePaginated = backgroundCheckPackagePaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListBackgroundCheckPackagesResponse build() {
            return new AtsListBackgroundCheckPackagesResponse(this.contentType, this.statusCode, this.rawResponse, this.backgroundCheckPackagePaginated, this.headers);
        }
    }
}

