/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.InAppTemplateResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingGetInAppTemplateResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends InAppTemplateResult> inAppTemplateResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingGetInAppTemplateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends InAppTemplateResult> inAppTemplateResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(inAppTemplateResult, "inAppTemplateResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.inAppTemplateResult = inAppTemplateResult;
        this.headers = headers;
    }

    public MarketingGetInAppTemplateResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InAppTemplateResult> inAppTemplateResult() {
        return this.inAppTemplateResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public MarketingGetInAppTemplateResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingGetInAppTemplateResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingGetInAppTemplateResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingGetInAppTemplateResponse withInAppTemplateResult(InAppTemplateResult inAppTemplateResult) {
        Utils.checkNotNull(inAppTemplateResult, "inAppTemplateResult");
        this.inAppTemplateResult = Optional.ofNullable(inAppTemplateResult);
        return this;
    }

    public MarketingGetInAppTemplateResponse withInAppTemplateResult(Optional<? extends InAppTemplateResult> inAppTemplateResult) {
        Utils.checkNotNull(inAppTemplateResult, "inAppTemplateResult");
        this.inAppTemplateResult = inAppTemplateResult;
        return this;
    }

    public MarketingGetInAppTemplateResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingGetInAppTemplateResponse other = (MarketingGetInAppTemplateResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.inAppTemplateResult, other.inAppTemplateResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.inAppTemplateResult, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingGetInAppTemplateResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "inAppTemplateResult", this.inAppTemplateResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends InAppTemplateResult> inAppTemplateResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder inAppTemplateResult(InAppTemplateResult inAppTemplateResult) {
            Utils.checkNotNull(inAppTemplateResult, "inAppTemplateResult");
            this.inAppTemplateResult = Optional.ofNullable(inAppTemplateResult);
            return this;
        }

        public Builder inAppTemplateResult(Optional<? extends InAppTemplateResult> inAppTemplateResult) {
            Utils.checkNotNull(inAppTemplateResult, "inAppTemplateResult");
            this.inAppTemplateResult = inAppTemplateResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingGetInAppTemplateResponse build() {
            return new MarketingGetInAppTemplateResponse(this.contentType, this.statusCode, this.rawResponse, this.inAppTemplateResult, this.headers);
        }
    }
}

