/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils.pagination;

import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.stackone.stackone_client_java.utils.pagination.ProgressTrackerStrategy;

public class CursorTracker<ProgressParamT>
implements ProgressTrackerStrategy<ProgressParamT> {
    private final String cursorExpression;
    private ProgressParamT currentCursor;
    private final Class<ProgressParamT> cursorType;

    public CursorTracker(String cursorExpression, Class<ProgressParamT> cursorType) {
        this.cursorExpression = cursorExpression;
        this.cursorType = cursorType;
    }

    @Override
    public boolean advance(ReadContext respJson) {
        Object cursor = respJson.read(this.cursorExpression, this.cursorType, new Predicate[0]);
        if (cursor == null) {
            return false;
        }
        this.currentCursor = cursor;
        return true;
    }

    @Override
    public ProgressParamT getPosition() {
        return this.currentCursor;
    }
}

