/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class InterviewPart {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends InterviewPartType> type;

    /**
     * The title of interview, usually corresponding to the title of an associated calendar event
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("title")
    private JsonNullable<String> title;

    /**
     * The user (interviewer) IDs taking part in this specific interview.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("interviewer_ids")
    private JsonNullable<? extends List<String>> interviewerIds;

    /**
     * Provider's user (interviewer) IDs taking part in this specific interview.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_interviewer_ids")
    private JsonNullable<? extends List<String>> remoteInterviewerIds;

    /**
     * The meeting URL for the interview - this may be populated using the underlying location if the location string extracted is a valid url.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("meeting_url")
    private JsonNullable<String> meetingUrl;

    /**
     * The video meeting provider used for the interview.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("meeting_provider")
    private JsonNullable<String> meetingProvider;

    /**
     * The specific interview part's start date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_at")
    private JsonNullable<OffsetDateTime> startAt;

    /**
     * The specific interview part's end date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_at")
    private JsonNullable<OffsetDateTime> endAt;

    /**
     * Interview part created date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * Interview part updated date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public InterviewPart(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("type") JsonNullable<? extends InterviewPartType> type,
            @JsonProperty("title") JsonNullable<String> title,
            @JsonProperty("interviewer_ids") JsonNullable<? extends List<String>> interviewerIds,
            @JsonProperty("remote_interviewer_ids") JsonNullable<? extends List<String>> remoteInterviewerIds,
            @JsonProperty("meeting_url") JsonNullable<String> meetingUrl,
            @JsonProperty("meeting_provider") JsonNullable<String> meetingProvider,
            @JsonProperty("start_at") JsonNullable<OffsetDateTime> startAt,
            @JsonProperty("end_at") JsonNullable<OffsetDateTime> endAt,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(title, "title");
        Utils.checkNotNull(interviewerIds, "interviewerIds");
        Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
        Utils.checkNotNull(meetingUrl, "meetingUrl");
        Utils.checkNotNull(meetingProvider, "meetingProvider");
        Utils.checkNotNull(startAt, "startAt");
        Utils.checkNotNull(endAt, "endAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.type = type;
        this.title = title;
        this.interviewerIds = interviewerIds;
        this.remoteInterviewerIds = remoteInterviewerIds;
        this.meetingUrl = meetingUrl;
        this.meetingProvider = meetingProvider;
        this.startAt = startAt;
        this.endAt = endAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public InterviewPart() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<InterviewPartType> type() {
        return (JsonNullable<InterviewPartType>) type;
    }

    /**
     * The title of interview, usually corresponding to the title of an associated calendar event
     */
    @JsonIgnore
    public JsonNullable<String> title() {
        return title;
    }

    /**
     * The user (interviewer) IDs taking part in this specific interview.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> interviewerIds() {
        return (JsonNullable<List<String>>) interviewerIds;
    }

    /**
     * Provider's user (interviewer) IDs taking part in this specific interview.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> remoteInterviewerIds() {
        return (JsonNullable<List<String>>) remoteInterviewerIds;
    }

    /**
     * The meeting URL for the interview - this may be populated using the underlying location if the location string extracted is a valid url.
     */
    @JsonIgnore
    public JsonNullable<String> meetingUrl() {
        return meetingUrl;
    }

    /**
     * The video meeting provider used for the interview.
     */
    @JsonIgnore
    public JsonNullable<String> meetingProvider() {
        return meetingProvider;
    }

    /**
     * The specific interview part's start date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startAt() {
        return startAt;
    }

    /**
     * The specific interview part's end date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endAt() {
        return endAt;
    }

    /**
     * Interview part created date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * Interview part updated date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public InterviewPart withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public InterviewPart withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public InterviewPart withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public InterviewPart withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public InterviewPart withType(InterviewPartType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    public InterviewPart withType(JsonNullable<? extends InterviewPartType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The title of interview, usually corresponding to the title of an associated calendar event
     */
    public InterviewPart withTitle(String title) {
        Utils.checkNotNull(title, "title");
        this.title = JsonNullable.of(title);
        return this;
    }

    /**
     * The title of interview, usually corresponding to the title of an associated calendar event
     */
    public InterviewPart withTitle(JsonNullable<String> title) {
        Utils.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    /**
     * The user (interviewer) IDs taking part in this specific interview.
     */
    public InterviewPart withInterviewerIds(List<String> interviewerIds) {
        Utils.checkNotNull(interviewerIds, "interviewerIds");
        this.interviewerIds = JsonNullable.of(interviewerIds);
        return this;
    }

    /**
     * The user (interviewer) IDs taking part in this specific interview.
     */
    public InterviewPart withInterviewerIds(JsonNullable<? extends List<String>> interviewerIds) {
        Utils.checkNotNull(interviewerIds, "interviewerIds");
        this.interviewerIds = interviewerIds;
        return this;
    }

    /**
     * Provider's user (interviewer) IDs taking part in this specific interview.
     */
    public InterviewPart withRemoteInterviewerIds(List<String> remoteInterviewerIds) {
        Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
        this.remoteInterviewerIds = JsonNullable.of(remoteInterviewerIds);
        return this;
    }

    /**
     * Provider's user (interviewer) IDs taking part in this specific interview.
     */
    public InterviewPart withRemoteInterviewerIds(JsonNullable<? extends List<String>> remoteInterviewerIds) {
        Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
        this.remoteInterviewerIds = remoteInterviewerIds;
        return this;
    }

    /**
     * The meeting URL for the interview - this may be populated using the underlying location if the location string extracted is a valid url.
     */
    public InterviewPart withMeetingUrl(String meetingUrl) {
        Utils.checkNotNull(meetingUrl, "meetingUrl");
        this.meetingUrl = JsonNullable.of(meetingUrl);
        return this;
    }

    /**
     * The meeting URL for the interview - this may be populated using the underlying location if the location string extracted is a valid url.
     */
    public InterviewPart withMeetingUrl(JsonNullable<String> meetingUrl) {
        Utils.checkNotNull(meetingUrl, "meetingUrl");
        this.meetingUrl = meetingUrl;
        return this;
    }

    /**
     * The video meeting provider used for the interview.
     */
    public InterviewPart withMeetingProvider(String meetingProvider) {
        Utils.checkNotNull(meetingProvider, "meetingProvider");
        this.meetingProvider = JsonNullable.of(meetingProvider);
        return this;
    }

    /**
     * The video meeting provider used for the interview.
     */
    public InterviewPart withMeetingProvider(JsonNullable<String> meetingProvider) {
        Utils.checkNotNull(meetingProvider, "meetingProvider");
        this.meetingProvider = meetingProvider;
        return this;
    }

    /**
     * The specific interview part's start date
     */
    public InterviewPart withStartAt(OffsetDateTime startAt) {
        Utils.checkNotNull(startAt, "startAt");
        this.startAt = JsonNullable.of(startAt);
        return this;
    }

    /**
     * The specific interview part's start date
     */
    public InterviewPart withStartAt(JsonNullable<OffsetDateTime> startAt) {
        Utils.checkNotNull(startAt, "startAt");
        this.startAt = startAt;
        return this;
    }

    /**
     * The specific interview part's end date
     */
    public InterviewPart withEndAt(OffsetDateTime endAt) {
        Utils.checkNotNull(endAt, "endAt");
        this.endAt = JsonNullable.of(endAt);
        return this;
    }

    /**
     * The specific interview part's end date
     */
    public InterviewPart withEndAt(JsonNullable<OffsetDateTime> endAt) {
        Utils.checkNotNull(endAt, "endAt");
        this.endAt = endAt;
        return this;
    }

    /**
     * Interview part created date
     */
    public InterviewPart withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * Interview part created date
     */
    public InterviewPart withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Interview part updated date
     */
    public InterviewPart withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * Interview part updated date
     */
    public InterviewPart withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InterviewPart other = (InterviewPart) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.title, other.title) &&
            Utils.enhancedDeepEquals(this.interviewerIds, other.interviewerIds) &&
            Utils.enhancedDeepEquals(this.remoteInterviewerIds, other.remoteInterviewerIds) &&
            Utils.enhancedDeepEquals(this.meetingUrl, other.meetingUrl) &&
            Utils.enhancedDeepEquals(this.meetingProvider, other.meetingProvider) &&
            Utils.enhancedDeepEquals(this.startAt, other.startAt) &&
            Utils.enhancedDeepEquals(this.endAt, other.endAt) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, type,
            title, interviewerIds, remoteInterviewerIds,
            meetingUrl, meetingProvider, startAt,
            endAt, createdAt, updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(InterviewPart.class,
                "id", id,
                "remoteId", remoteId,
                "type", type,
                "title", title,
                "interviewerIds", interviewerIds,
                "remoteInterviewerIds", remoteInterviewerIds,
                "meetingUrl", meetingUrl,
                "meetingProvider", meetingProvider,
                "startAt", startAt,
                "endAt", endAt,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends InterviewPartType> type = JsonNullable.undefined();

        private JsonNullable<String> title = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> interviewerIds = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> remoteInterviewerIds = JsonNullable.undefined();

        private JsonNullable<String> meetingUrl = JsonNullable.undefined();

        private JsonNullable<String> meetingProvider = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> startAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> endAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        public Builder type(InterviewPartType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        public Builder type(JsonNullable<? extends InterviewPartType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * The title of interview, usually corresponding to the title of an associated calendar event
         */
        public Builder title(String title) {
            Utils.checkNotNull(title, "title");
            this.title = JsonNullable.of(title);
            return this;
        }

        /**
         * The title of interview, usually corresponding to the title of an associated calendar event
         */
        public Builder title(JsonNullable<String> title) {
            Utils.checkNotNull(title, "title");
            this.title = title;
            return this;
        }


        /**
         * The user (interviewer) IDs taking part in this specific interview.
         */
        public Builder interviewerIds(List<String> interviewerIds) {
            Utils.checkNotNull(interviewerIds, "interviewerIds");
            this.interviewerIds = JsonNullable.of(interviewerIds);
            return this;
        }

        /**
         * The user (interviewer) IDs taking part in this specific interview.
         */
        public Builder interviewerIds(JsonNullable<? extends List<String>> interviewerIds) {
            Utils.checkNotNull(interviewerIds, "interviewerIds");
            this.interviewerIds = interviewerIds;
            return this;
        }


        /**
         * Provider's user (interviewer) IDs taking part in this specific interview.
         */
        public Builder remoteInterviewerIds(List<String> remoteInterviewerIds) {
            Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
            this.remoteInterviewerIds = JsonNullable.of(remoteInterviewerIds);
            return this;
        }

        /**
         * Provider's user (interviewer) IDs taking part in this specific interview.
         */
        public Builder remoteInterviewerIds(JsonNullable<? extends List<String>> remoteInterviewerIds) {
            Utils.checkNotNull(remoteInterviewerIds, "remoteInterviewerIds");
            this.remoteInterviewerIds = remoteInterviewerIds;
            return this;
        }


        /**
         * The meeting URL for the interview - this may be populated using the underlying location if the location string extracted is a valid url.
         */
        public Builder meetingUrl(String meetingUrl) {
            Utils.checkNotNull(meetingUrl, "meetingUrl");
            this.meetingUrl = JsonNullable.of(meetingUrl);
            return this;
        }

        /**
         * The meeting URL for the interview - this may be populated using the underlying location if the location string extracted is a valid url.
         */
        public Builder meetingUrl(JsonNullable<String> meetingUrl) {
            Utils.checkNotNull(meetingUrl, "meetingUrl");
            this.meetingUrl = meetingUrl;
            return this;
        }


        /**
         * The video meeting provider used for the interview.
         */
        public Builder meetingProvider(String meetingProvider) {
            Utils.checkNotNull(meetingProvider, "meetingProvider");
            this.meetingProvider = JsonNullable.of(meetingProvider);
            return this;
        }

        /**
         * The video meeting provider used for the interview.
         */
        public Builder meetingProvider(JsonNullable<String> meetingProvider) {
            Utils.checkNotNull(meetingProvider, "meetingProvider");
            this.meetingProvider = meetingProvider;
            return this;
        }


        /**
         * The specific interview part's start date
         */
        public Builder startAt(OffsetDateTime startAt) {
            Utils.checkNotNull(startAt, "startAt");
            this.startAt = JsonNullable.of(startAt);
            return this;
        }

        /**
         * The specific interview part's start date
         */
        public Builder startAt(JsonNullable<OffsetDateTime> startAt) {
            Utils.checkNotNull(startAt, "startAt");
            this.startAt = startAt;
            return this;
        }


        /**
         * The specific interview part's end date
         */
        public Builder endAt(OffsetDateTime endAt) {
            Utils.checkNotNull(endAt, "endAt");
            this.endAt = JsonNullable.of(endAt);
            return this;
        }

        /**
         * The specific interview part's end date
         */
        public Builder endAt(JsonNullable<OffsetDateTime> endAt) {
            Utils.checkNotNull(endAt, "endAt");
            this.endAt = endAt;
            return this;
        }


        /**
         * Interview part created date
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * Interview part created date
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * Interview part updated date
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * Interview part updated date
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public InterviewPart build() {

            return new InterviewPart(
                id, remoteId, type,
                title, interviewerIds, remoteInterviewerIds,
                meetingUrl, meetingProvider, startAt,
                endAt, createdAt, updatedAt);
        }

    }
}
