/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.LmsCreateContentRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;

public class LmsUpdateContentRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private LmsCreateContentRequestDto lmsCreateContentRequestDto;

    @JsonCreator
    public LmsUpdateContentRequest(String xAccountId, String id, LmsCreateContentRequestDto lmsCreateContentRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(lmsCreateContentRequestDto, "lmsCreateContentRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.lmsCreateContentRequestDto = lmsCreateContentRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public LmsCreateContentRequestDto lmsCreateContentRequestDto() {
        return this.lmsCreateContentRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LmsUpdateContentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public LmsUpdateContentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public LmsUpdateContentRequest withLmsCreateContentRequestDto(LmsCreateContentRequestDto lmsCreateContentRequestDto) {
        Utils.checkNotNull(lmsCreateContentRequestDto, "lmsCreateContentRequestDto");
        this.lmsCreateContentRequestDto = lmsCreateContentRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LmsUpdateContentRequest other = (LmsUpdateContentRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.lmsCreateContentRequestDto, other.lmsCreateContentRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.lmsCreateContentRequestDto);
    }

    public String toString() {
        return Utils.toString(LmsUpdateContentRequest.class, "xAccountId", this.xAccountId, "id", this.id, "lmsCreateContentRequestDto", this.lmsCreateContentRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private LmsCreateContentRequestDto lmsCreateContentRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder lmsCreateContentRequestDto(LmsCreateContentRequestDto lmsCreateContentRequestDto) {
            Utils.checkNotNull(lmsCreateContentRequestDto, "lmsCreateContentRequestDto");
            this.lmsCreateContentRequestDto = lmsCreateContentRequestDto;
            return this;
        }

        public LmsUpdateContentRequest build() {
            return new LmsUpdateContentRequest(this.xAccountId, this.id, this.lmsCreateContentRequestDto);
        }
    }
}

