/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class AdditionalData {
    /**
     * The name of the additional data field. Speak to your Solutions Engineer to understand the id for the specific use case
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The value of the additional data
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends AdditionalDataValue> value;

    @JsonCreator
    public AdditionalData(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("value") JsonNullable<? extends AdditionalDataValue> value) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(value, "value");
        this.id = id;
        this.remoteId = remoteId;
        this.value = value;
    }
    
    public AdditionalData() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The name of the additional data field. Speak to your Solutions Engineer to understand the id for the specific use case
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The value of the additional data
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AdditionalDataValue> value() {
        return (JsonNullable<AdditionalDataValue>) value;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The name of the additional data field. Speak to your Solutions Engineer to understand the id for the specific use case
     */
    public AdditionalData withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The name of the additional data field. Speak to your Solutions Engineer to understand the id for the specific use case
     */
    public AdditionalData withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AdditionalData withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public AdditionalData withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The value of the additional data
     */
    public AdditionalData withValue(AdditionalDataValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The value of the additional data
     */
    public AdditionalData withValue(JsonNullable<? extends AdditionalDataValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AdditionalData other = (AdditionalData) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.value, other.value);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, value);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AdditionalData.class,
                "id", id,
                "remoteId", remoteId,
                "value", value);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends AdditionalDataValue> value = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The name of the additional data field. Speak to your Solutions Engineer to understand the id for the specific use case
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The name of the additional data field. Speak to your Solutions Engineer to understand the id for the specific use case
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The value of the additional data
         */
        public Builder value(AdditionalDataValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The value of the additional data
         */
        public Builder value(JsonNullable<? extends AdditionalDataValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public AdditionalData build() {

            return new AdditionalData(
                id, remoteId, value);
        }

    }
}
