/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class Answer {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Type of the answer
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends AnswerType> type;

    /**
     * Values of the answer
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("values")
    private JsonNullable<? extends List<String>> values;

    @JsonCreator
    public Answer(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("type") JsonNullable<? extends AnswerType> type,
            @JsonProperty("values") JsonNullable<? extends List<String>> values) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(values, "values");
        this.id = id;
        this.remoteId = remoteId;
        this.type = type;
        this.values = values;
    }
    
    public Answer() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Type of the answer
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AnswerType> type() {
        return (JsonNullable<AnswerType>) type;
    }

    /**
     * Values of the answer
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> values() {
        return (JsonNullable<List<String>>) values;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public Answer withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Answer withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Answer withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Answer withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Type of the answer
     */
    public Answer withType(AnswerType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * Type of the answer
     */
    public Answer withType(JsonNullable<? extends AnswerType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * Values of the answer
     */
    public Answer withValues(List<String> values) {
        Utils.checkNotNull(values, "values");
        this.values = JsonNullable.of(values);
        return this;
    }

    /**
     * Values of the answer
     */
    public Answer withValues(JsonNullable<? extends List<String>> values) {
        Utils.checkNotNull(values, "values");
        this.values = values;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Answer other = (Answer) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.values, other.values);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, type,
            values);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Answer.class,
                "id", id,
                "remoteId", remoteId,
                "type", type,
                "values", values);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends AnswerType> type = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> values = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Type of the answer
         */
        public Builder type(AnswerType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * Type of the answer
         */
        public Builder type(JsonNullable<? extends AnswerType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * Values of the answer
         */
        public Builder values(List<String> values) {
            Utils.checkNotNull(values, "values");
            this.values = JsonNullable.of(values);
            return this;
        }

        /**
         * Values of the answer
         */
        public Builder values(JsonNullable<? extends List<String>> values) {
            Utils.checkNotNull(values, "values");
            this.values = values;
            return this;
        }

        public Answer build() {

            return new Answer(
                id, remoteId, type,
                values);
        }

    }
}
