/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class ApplicationAttachmentContentType {
    /**
     * The content type of the attachment.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends ApplicationAttachmentValue> value;

    /**
     * The source value of the content type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends ApplicationAttachmentSourceValue> sourceValue;

    @JsonCreator
    public ApplicationAttachmentContentType(
            @JsonProperty("value") JsonNullable<? extends ApplicationAttachmentValue> value,
            @JsonProperty("source_value") JsonNullable<? extends ApplicationAttachmentSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public ApplicationAttachmentContentType() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The content type of the attachment.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApplicationAttachmentValue> value() {
        return (JsonNullable<ApplicationAttachmentValue>) value;
    }

    /**
     * The source value of the content type.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApplicationAttachmentSourceValue> sourceValue() {
        return (JsonNullable<ApplicationAttachmentSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The content type of the attachment.
     */
    public ApplicationAttachmentContentType withValue(ApplicationAttachmentValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The content type of the attachment.
     */
    public ApplicationAttachmentContentType withValue(JsonNullable<? extends ApplicationAttachmentValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the content type.
     */
    public ApplicationAttachmentContentType withSourceValue(ApplicationAttachmentSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the content type.
     */
    public ApplicationAttachmentContentType withSourceValue(JsonNullable<? extends ApplicationAttachmentSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationAttachmentContentType other = (ApplicationAttachmentContentType) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ApplicationAttachmentContentType.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends ApplicationAttachmentValue> value = JsonNullable.undefined();

        private JsonNullable<? extends ApplicationAttachmentSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The content type of the attachment.
         */
        public Builder value(ApplicationAttachmentValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The content type of the attachment.
         */
        public Builder value(JsonNullable<? extends ApplicationAttachmentValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the content type.
         */
        public Builder sourceValue(ApplicationAttachmentSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the content type.
         */
        public Builder sourceValue(JsonNullable<? extends ApplicationAttachmentSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public ApplicationAttachmentContentType build() {

            return new ApplicationAttachmentContentType(
                value, sourceValue);
        }

    }
}
