/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class ApplicationStatus {
    /**
     * The status of the application.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends ApplicationValue> value;

    /**
     * The source value of the application status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends ApplicationSourceValue> sourceValue;

    @JsonCreator
    public ApplicationStatus(
            @JsonProperty("value") JsonNullable<? extends ApplicationValue> value,
            @JsonProperty("source_value") JsonNullable<? extends ApplicationSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public ApplicationStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The status of the application.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApplicationValue> value() {
        return (JsonNullable<ApplicationValue>) value;
    }

    /**
     * The source value of the application status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ApplicationSourceValue> sourceValue() {
        return (JsonNullable<ApplicationSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The status of the application.
     */
    public ApplicationStatus withValue(ApplicationValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The status of the application.
     */
    public ApplicationStatus withValue(JsonNullable<? extends ApplicationValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the application status.
     */
    public ApplicationStatus withSourceValue(ApplicationSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the application status.
     */
    public ApplicationStatus withSourceValue(JsonNullable<? extends ApplicationSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationStatus other = (ApplicationStatus) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ApplicationStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends ApplicationValue> value = JsonNullable.undefined();

        private JsonNullable<? extends ApplicationSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The status of the application.
         */
        public Builder value(ApplicationValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The status of the application.
         */
        public Builder value(JsonNullable<? extends ApplicationValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the application status.
         */
        public Builder sourceValue(ApplicationSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the application status.
         */
        public Builder sourceValue(JsonNullable<? extends ApplicationSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public ApplicationStatus build() {

            return new ApplicationStatus(
                value, sourceValue);
        }

    }
}
